package ru.yandex.ace.ventura.salo.handlers2.tags;

import java.io.IOException;
import java.util.List;
import java.util.function.BiFunction;

import ru.yandex.ace.ventura.AceVenturaFields;
import ru.yandex.ace.ventura.salo.AceVenturaIndexContext;
import ru.yandex.ace.ventura.salo.AceVenturaMdbsContext;
import ru.yandex.ace.ventura.salo.UpdateAceVenturaEnvelope;
import ru.yandex.ace.ventura.salo.handlers2.AbstractAceVenturaIndexHandler2;
import ru.yandex.ace.ventura.salo.handlers2.AceVenturaHandlerUtils;
import ru.yandex.dbfields.CollieFields;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonLong;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.JsonString;
import ru.yandex.json.parser.JsonException;
import ru.yandex.search.salo.Envelope;
import ru.yandex.search.salo.Mdb;
import ru.yandex.search.salo.PingEnvelope;

public class UnTagEmailsHandler extends AbstractAceVenturaIndexHandler2 {
    private static final BiFunction<JsonObject, JsonMap, JsonMap> DEL_TAG =
        AceVenturaHandlerUtils.INSTANCE.removeSet(
            AceVenturaFields.TAGS.stored());
    private static final BiFunction<JsonObject, JsonMap, JsonMap> DEL_ETAG =
        AceVenturaHandlerUtils.INSTANCE.removeSet(
            AceVenturaFields.EMAIL_TAGS.stored());

    public UnTagEmailsHandler(final AceVenturaMdbsContext context) {
        super(context);
    }

    @Override
    public void handle(
        final AceVenturaIndexContext context,
        final List<Envelope> storage)
        throws IOException, JsonException
    {
        JsonMap result = new JsonMap(BasicContainerFactory.INSTANCE);
        result.put("prefix", new JsonString(context.prefix().toStringFast()));
        JsonList docsList = new JsonList(BasicContainerFactory.INSTANCE);

        JsonMap args = context.arguments();
        Long tagId = args.getLong(CollieFields.TAG_ID, null);
        if (tagId == null) {
            context.logger().warning(
                "Tag id null, looks like delete for contact, skipping record");
            storage.add(
                new PingEnvelope(
                    context.changeId(),
                    context.envelopesContext(),
                    (int) (context.prefix().hash() % Mdb.SHARDS)));
            return;
        }
        JsonList emailsIds = args.getList(CollieFields.EMAIL_IDS);
        if (emailsIds.size() == 0) {
            context.logger().warning(
                "TagEmails empty list of emails ids "
                    + context.toString());
            return;
        }

        for (JsonObject jo: emailsIds) {
            String emailId = jo.asString();
            String aceEmailId = AceVenturaFields.emailUrl(
                emailId,
                context.prefix(),
                context.prefix());

            JsonMap doc = new JsonMap(BasicContainerFactory.INSTANCE);
            doc.put(AceVenturaFields.ID.field(), new JsonString(aceEmailId));
            DEL_TAG.apply(new JsonLong(tagId), doc);
            DEL_ETAG.apply(new JsonLong(tagId), doc);
            doc.put(
                AceVenturaFields.REVISION.field(),
                new JsonLong(context.revision()));
            docsList.add(doc);
        }

        result.put("docs", docsList);

        storage.add(
            new UpdateAceVenturaEnvelope(
                context,
                result,
                docsList.size()));
    }
}
