package ru.yandex.ace.ventura.salo.mdb;

import java.util.Map;
import java.util.Set;

import org.apache.http.HttpHost;

public class BasicSaloMdbMap implements SaloShardMap {
    private final HttpHost currentHost;
    private final Map<String, Set<HttpHost>> mdbToHost;
    private final Map<HttpHost, Set<String>> hostToMdb;

    public BasicSaloMdbMap(
        final HttpHost currentHost,
        final Map<String, Set<HttpHost>> mdbToHost,
        final Map<HttpHost, Set<String>> hostToMdb)
    {
        this.currentHost = currentHost;
        this.mdbToHost = mdbToHost;
        this.hostToMdb = hostToMdb;
    }

    @Override
    public Set<HttpHost> saloHosts(final String mdb) {
        return mdbToHost.get(mdb);
    }

    @Override
    public Set<String> mdbs() {
        return hostToMdb.get(currentHost);
    }
}
