package ru.yandex.ace.ventura.salo.mdb;

import java.util.Collections;
import java.util.Set;

import org.apache.http.HttpHost;

public class IdentitySaloShardsMapFactory implements SaloShardsMapFactory {
    public static final IdentitySaloShardsMapFactory INSTANCE
        = new IdentitySaloShardsMapFactory();

    private final Set<HttpHost> hosts;

    public IdentitySaloShardsMapFactory() {
        int port = Integer.parseInt(System.getProperty("BSCONFIG_IPORT", "81"));
        hosts = Collections.singleton(new HttpHost("localhost", port));
    }

    @Override
    public SaloShardMap create(Set<String> mdbs) {
        return new IdentitySaloMdbMap(hosts, mdbs);
    }
}
