package ru.yandex.ace.ventura.salo.mdb;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.search.salo.Salo;

public enum MdbUpdaterType {
    MSAL {
        @Override
        public MdbShardsSupplier create(
            final Salo salo,
            final ImmutableHttpHostConfig msalConfig)
        {
            return new MsalMdbSupplier(salo, msalConfig);
        }
    };


    public abstract MdbShardsSupplier create(
        final Salo salo,
        final ImmutableHttpHostConfig msalConfig);
}
