package ru.yandex.ace.ventura.salo.mdb;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.util.CharsetUtils;
import ru.yandex.http.util.client.ClientBuilder;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.TypesafeValueContentHandler;
import ru.yandex.json.parser.JsonException;
import ru.yandex.search.salo.Salo;

public class MsalMdbSupplier implements MdbShardsSupplier {
    private final CloseableHttpClient client;
    private final ImmutableHttpHostConfig msalConfig;

    public MsalMdbSupplier(
        final Salo salo,
        final ImmutableHttpHostConfig msalHostConfig)
    {
        this.client = ClientBuilder.createClient(
            msalHostConfig,
            salo.config().dnsConfig());
        this.msalConfig = msalHostConfig;
    }

    @Override
    public Set<String> get() throws IOException {
        Set<String> result = new LinkedHashSet<>();

        String uri = msalConfig.host().toString() + "/list-shards";
        try (CloseableHttpResponse response =
                 client.execute(new HttpGet(uri)))
        {
            if (response.getStatusLine().getStatusCode() != HttpStatus.SC_OK) {
                throw new IOException(
                    uri + " responded with code "
                        + response.getStatusLine().getStatusCode());
            }

            JsonList shards =
                TypesafeValueContentHandler.parse(
                    CharsetUtils.content(response.getEntity())).asList();

            for (JsonObject jo: shards) {
                result.add(jo.asString());
            }
        } catch (HttpException | ClientProtocolException | JsonException ce) {
            throw new IOException(ce);
        }

        return result;
    }
}
