package ru.yandex.mail.search.staff;

import java.util.Locale;

import ru.yandex.ace.ventura.AceStaffPosition;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;

public class Person {
    private final String login;
    private final String email;
    private final String language;
    private final String englishNames;
    private final String messengersLogins;
    private final String positionName;
    private final AceStaffPosition positionType;
    private final Long messageId;
    private final Long uid;
    private final Long depId;
    private final String departments;
    private final Long depLevel;
    private final boolean dismissed;
    private final boolean robot;

    //CSOFF: ParameterNumber
    public Person(final JsonMap item) throws JsonException {
        JsonMap official = item.getMap("official");
        language =
            item.getMap("language").getString("native").trim()
                .toLowerCase(Locale.ROOT);
        login = item.getString("login");
        messageId = item.getLong("id");
        uid = item.getLong("uid");
        dismissed = official.getBoolean("is_dismissed", false);
        robot = official.getBoolean("is_robot", false);

        JsonMap nameMap = item.getMapOrNull("name");
        StringBuilder englishNamesSb = new StringBuilder();
        if (nameMap != null) {
            JsonMap first = nameMap.getMapOrNull("first");
            if (first != null) {
                String en = first.getString("en");
                if (en != null) {
                    englishNamesSb.append(en);
                }
            }

            JsonMap last = nameMap.getMapOrNull("last");
            if (last != null) {
                String en = last.getString("en");
                if (en != null) {
                    if (englishNamesSb.length() > 0) {
                        englishNamesSb.append('\t');
                    }
                    englishNamesSb.append(en);
                }
            }
        }

        englishNames = englishNamesSb.toString();
        email = item.getString("work_email");

        JsonMap positionMap = official.getMap("position");
        positionName = positionMap.getString("en").toLowerCase(Locale.ENGLISH);
        String positionRu = positionMap.getString("ru").toLowerCase(Locale.ROOT);
        if (positionRu.contains("директор")) {
            positionType = AceStaffPosition.DIRECTOR;
        } else if (positionName.contains("head") || positionName.contains("leader")) {
            positionType = AceStaffPosition.HEAD_DEPARTMENT;
        } else if (positionName.contains("manager")) {
            positionType = AceStaffPosition.MANAGER;
        } else if (positionRu.contains("hr")) {
            positionType = AceStaffPosition.HR;
        } else {
            positionType = AceStaffPosition.OTHER;
        }

        StringBuilder messengersLogins = new StringBuilder();
        for (JsonObject accountObj: item.getList("accounts")) {
            JsonMap account = accountObj.asMap();
            boolean privateOne = account.getBoolean("private", false);
            if (privateOne) {
                continue;
            }

            if ("telegram".equalsIgnoreCase(account.getString("type"))) {
                String value = account.getString("value_lower");
                if (!value.isEmpty()) {
                    messengersLogins.append(value);
                    messengersLogins.append('\n');
                }
            }
        }

        if (messengersLogins.length() > 0) {
            messengersLogins.setLength(messengersLogins.length() - 1);
        }

        this.messengersLogins = messengersLogins.toString();
        JsonMap depGroup = item.getMap("department_group");
        depId = depGroup.getLong("id");
        StringBuilder depsSb = new StringBuilder();
        for (JsonObject ancestor: depGroup.getList("ancestors")) {
            JsonMap map = ancestor.asMap();
            depsSb.append(map.getLong("id"));
            depsSb.append('\n');
        }

        depsSb.append(depId);
        this.departments = depsSb.toString();
        this.depLevel = depGroup.getLong("level");
    }
    //CSON: ParameterNumber

    public String login() {
        return login;
    }

    public String email() {
        return email;
    }

    public boolean dismissed() {
        return dismissed;
    }

    public Long messageId() {
        return messageId;
    }

    public Long uid() {
        return uid;
    }

    public String language() {
        return language;
    }

    public String messengersLogins() {
        return messengersLogins;
    }

    public String positionName() {
        return positionName;
    }

    public AceStaffPosition positionType() {
        return positionType;
    }

    public Long depId() {
        return depId;
    }

    public String departments() {
        return departments;
    }

    public Long depLevel() {
        return depLevel;
    }

    public boolean robot() {
        return robot;
    }

    public String englishNames() {
        return englishNames;
    }

    @Override
    public String toString() {
        return "Person{" +
            "login='" + login + '\'' +
            ", email='" + email + '\'' +
            ", language='" + language + '\'' +
            ", messengersLogins='" + messengersLogins + '\'' +
            ", positionName='" + positionName + '\'' +
            ", positionType=" + positionType +
            ", messageId=" + messageId +
            ", uid=" + uid +
            ", depId=" + depId +
            ", departments='" + departments + '\'' +
            ", depLevel=" + depLevel +
            ", dismissed=" + dismissed +
            ", robot=" + robot +
            ", englishNames=" + englishNames +
            '}';
    }
}
