package ru.yandex.mail.search.staff;

import java.util.LinkedHashMap;
import java.util.Map;

import ru.yandex.mail.search.staff.consumer.StaffMessage;

public class StaffMessageIdGrouppedPage {
    private String next;
    private int total;
    private long maxId;
    private long minId;
    private final LinkedHashMap<Long, StaffMessage> messages;

    public StaffMessageIdGrouppedPage(
        final LinkedHashMap<Long, StaffMessage> messages,
        final String next,
        final long minId,
        final long maxId,
        final int total)
    {
        this.next = next;
        this.total = total;
        this.messages = messages;
        this.maxId = maxId;
        this.minId = minId;
    }

    public String next() {
        return next;
    }

    public Map<Long, StaffMessage> messages() {
        return messages;
    }

    public void appendNext(final StaffMessageIdGrouppedPage next) {
        for (Map.Entry<Long, StaffMessage> entry: next.messages().entrySet()) {
            StaffMessage message = messages.get(entry.getKey());
            if (message == null) {
                messages.put(entry.getKey(), entry.getValue());
            } else {
                for (Person person: entry.getValue().people()) {
                    message.add(person);
                }
            }
        }

        System.err.println("Appended " + this.messages);

        total += next.total;
        this.next = next.next;

        if (next.maxId > maxId) {
            maxId = next.maxId;
        }
    }

    public long maxId() {
        return maxId;
    }

    public long minId() {
        return minId;
    }

    public int total() {
        return total;
    }

    @Override
    public String toString() {
        return "StaffPage{" +
            "next='" + next + '\'' +
            ", total=" + total +
            ", maxId=" + maxId +
            '}';
    }
}
