package ru.yandex.mail.search.staff.config;

import ru.yandex.ace.ventura.AceVenturaPrefix;
import ru.yandex.ace.ventura.AceVenturaPrefixParser;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.http.config.URIConfig;
import ru.yandex.http.config.URIConfigBuilder;
import ru.yandex.http.util.server.AbstractHttpProxyConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.searchmap.SearchMapConfig;
import ru.yandex.parser.searchmap.SearchMapConfigBuilder;
import ru.yandex.parser.string.PositiveIntegerValidator;

public abstract class AbstractStaffConsumerConfigBuilder
    <T extends AbstractStaffConsumerConfigBuilder<T>>
    extends AbstractHttpProxyConfigBuilder<T>
    implements StaffConsumerConfig
{
    private int checkInterval;
    private String token;
    private HttpHostConfigBuilder producerConfig;
    private String service;
    private long lockTimeout;
    private URIConfigBuilder staffClientConfig;
    private String producerName;
    private AceVenturaPrefix updatePrefix;
    private SearchMapConfigBuilder searchmap;
    private int searchBackendShards;

    protected AbstractStaffConsumerConfigBuilder(
        final StaffConsumerConfig config)
    {
        super(config);

        this.checkInterval(config.checkInterval());
        this.token(config.token());
        this.producerConfig(config.producerConfig());
        this.service(config.service());
        this.lockTimeout(config.lockTimeout());
        this.staffClientConfig(config.staffClientConfig());
        this.producerName(config.producerName());
        this.updatePrefix(config.updatePrefix());
        this.searchBackendShards(config.searchBackendShards());
        this.searchmap(config.searchmap());
    }

    protected AbstractStaffConsumerConfigBuilder(
        final IniConfig config,
        final StaffConsumerConfig defaults)
        throws ConfigException
    {
        super(config, defaults);

        checkInterval =
            config.getInt("check-interval", defaults.checkInterval());
        token = config.getString("token", defaults.token());
        producerConfig =
            new HttpHostConfigBuilder(
                config.section("producer"),
                defaults.producerConfig());
        service = config.getString("service", defaults.service());
        lockTimeout = config.getLong(
            "lock-timeout",
            defaults.lockTimeout());
        staffClientConfig =
            new URIConfigBuilder(
                config.section("staff"),
                defaults.staffClientConfig());
        producerName =
            config.getString(
                "producer-name",
                defaults.producerName());
        updatePrefix =
            config.get(
                "update-prefix",
                defaults.updatePrefix(),
                new AceVenturaPrefixParser());
        searchmap =
            new SearchMapConfigBuilder(
                config.section("searchmap"),
                defaults.searchmap());
        searchBackendShards =
            config.get(
                "search-backend-shards",
                defaults.searchBackendShards(),
                PositiveIntegerValidator.INSTANCE);
    }

    @Override
    public int checkInterval() {
        return checkInterval;
    }

    public T checkInterval(final int checkInterval) {
        this.checkInterval = checkInterval;
        return self();
    }

    @Override
    public String token() {
        return token;
    }

    public T token(final String token) {
        this.token = token;
        return self();
    }

    @Override
    public HttpHostConfigBuilder producerConfig() {
        return producerConfig;
    }

    public T producerConfig(final HttpHostConfig producerConfig) {
        this.producerConfig = new HttpHostConfigBuilder(producerConfig);
        return self();
    }

    @Override
    public String service() {
        return service;
    }

    public T service(final String service) {
        this.service = service;
        return self();
    }

    @Override
    public long lockTimeout() {
        return lockTimeout;
    }

    public T lockTimeout(final long lockTimeout) {
        this.lockTimeout = lockTimeout;
        return self();
    }

    @Override
    public URIConfigBuilder staffClientConfig() {
        return staffClientConfig;
    }

    public T staffClientConfig(final URIConfig staffClientConfig) {
        this.staffClientConfig = new URIConfigBuilder(staffClientConfig);
        return self();
    }

    @Override
    public String producerName() {
        return producerName;
    }

    public T producerName(final String producerName) {
        this.producerName = producerName;
        return self();
    }

    @Override
    public AceVenturaPrefix updatePrefix() {
        return updatePrefix;
    }

    public T updatePrefix(final AceVenturaPrefix prefix) {
        this.updatePrefix = prefix;
        return self();
    }

    @Override
    public int searchBackendShards() {
        return searchBackendShards;
    }

    public T searchBackendShards(final int luceneShards) {
        this.searchBackendShards = luceneShards;
        return self();
    }

    @Override
    public SearchMapConfigBuilder searchmap() {
        return searchmap;
    }

    public T searchmap(final SearchMapConfig searchmap) {
        this.searchmap = new SearchMapConfigBuilder(searchmap);
        return self();
    }
}
