package ru.yandex.mail.search.staff.config;

import ru.yandex.ace.ventura.AceVenturaPrefix;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.config.ImmutableURIConfig;
import ru.yandex.http.util.server.ImmutableHttpProxyConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.searchmap.ImmutableSearchMapConfig;

public class ImmutableStaffConsumerConfig
    extends ImmutableHttpProxyConfig
    implements StaffConsumerConfig
{
    private final int checkInterval;
    private final String token;
    private final ImmutableHttpHostConfig producerConfig;
    private final ImmutableSearchMapConfig searchMapConfig;
    private final String service;
    private final long lockTimeout;
    private final ImmutableURIConfig staffClientConfig;
    private final String producerName;
    private final AceVenturaPrefix updatePrefix;
    private final int searchBackendShards;

    public ImmutableStaffConsumerConfig(
        final StaffConsumerConfig config)
        throws ConfigException
    {
        super(config);

        this.producerName = config.producerName();
        this.checkInterval = config.checkInterval();
        this.token = config.token();
        this.service = config.service();
        this.lockTimeout = config.lockTimeout();
        this.staffClientConfig =
            new ImmutableURIConfig(
                config.staffClientConfig());
        this.producerConfig =
            new ImmutableHttpHostConfig(config.producerConfig());
        this.updatePrefix = config.updatePrefix();
        this.searchBackendShards = config.searchBackendShards();
        this.searchMapConfig = new ImmutableSearchMapConfig(config.searchmap());
        if (this.searchBackendShards <= 0) {
            throw new ConfigException("Lucene shards less or equal 0 " + this.searchBackendShards);
        }
    }

    @Override
    public int checkInterval() {
        return checkInterval;
    }

    @Override
    public String token() {
        return token;
    }

    @Override
    public ImmutableHttpHostConfig producerConfig() {
        return producerConfig;
    }

    @Override
    public String service() {
        return service;
    }

    @Override
    public long lockTimeout() {
        return lockTimeout;
    }

    @Override
    public ImmutableURIConfig staffClientConfig() {
        return staffClientConfig;
    }

    @Override
    public String producerName() {
        return producerName;
    }

    @Override
    public AceVenturaPrefix updatePrefix() {
        return updatePrefix;
    }

    @Override
    public int searchBackendShards() {
        return searchBackendShards;
    }

    @Override
    public ImmutableSearchMapConfig searchmap() {
        return searchMapConfig;
    }
}
