package ru.yandex.mail.search.staff.consumer;

import java.io.IOException;
import java.nio.charset.StandardCharsets;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;
import org.apache.http.entity.StringEntity;

import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.mail.search.staff.Person;

public class GetInfoHandler implements ProxyRequestHandler {
    private final StaffClient2 staffClient;

    public GetInfoHandler(final StaffClient2 staffClient) {
        this.staffClient = staffClient;
    }

    @Override
    public void handle(final ProxySession session) throws HttpException, IOException {
        String login = session.params().getString("login");
        try {
            Person person = staffClient.one(login);

            StringBuilderWriter sbw = new StringBuilderWriter();
            try (JsonWriter jw = JsonType.NORMAL.create(sbw)) {
                jw.startObject();
                if (person != null) {
                    StaffConsumer.writePerson(person, jw);
                }

                jw.endObject();
            }

            session.response(HttpStatus.SC_OK, new StringEntity(sbw.toString(), StandardCharsets.UTF_8));
        } catch (InterruptedException ie) {
            session.response(HttpStatus.SC_INTERNAL_SERVER_ERROR);
        }
    }
}
