package ru.yandex.mail.search.staff.consumer;

import java.util.LinkedHashMap;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.protocol.HttpContext;

import ru.yandex.json.async.consumer.AbstractJsonAsyncTypesafeDomConsumer;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.StringCollectorsFactory;
import ru.yandex.mail.search.staff.Person;
import ru.yandex.mail.search.staff.StaffMessageIdGrouppedPage;

public class PersonsConsumer
    extends AbstractJsonAsyncTypesafeDomConsumer<StaffMessageIdGrouppedPage>
{
    public PersonsConsumer(final HttpEntity entity) throws HttpException {
        super(
            entity,
            StringCollectorsFactory.INSTANCE,
            BasicContainerFactory.INSTANCE);
    }

    @Override
    protected StaffMessageIdGrouppedPage buildResult(
        final HttpContext context,
        final JsonObject rootObj)
        throws Exception
    {
        JsonMap root = rootObj.asMap();
        JsonMap links = root.getMap("links");
        String next = links.getString("next", null);

        JsonList results = root.getList("result");
        LinkedHashMap<Long, StaffMessage> messages = new LinkedHashMap<>();
        long maxMesId = -1L;
        long minMesId = Long.MAX_VALUE;
        for (JsonObject itemObj: results) {
            JsonMap item = itemObj.asMap();
            long mesId = item.getMap("_meta").getLong("message_id");
            if (mesId > maxMesId) {
                maxMesId = mesId;
            }

            if (mesId < minMesId) {
                minMesId = mesId;
            }
            JsonMap official = item.getMap("official");
            if (official.getBoolean("is_robot", false)) {
                continue;
            }

            Person person = new Person(item);
            messages.computeIfAbsent(person.messageId(), StaffMessage::new).add(person);
        }

        return new StaffMessageIdGrouppedPage(messages, next, minMesId, maxMesId, results.size());
    }
}
