package ru.yandex.mail.search.staff.consumer;

import java.io.IOException;

import ru.yandex.collection.Pattern;
import ru.yandex.http.proxy.HttpProxy;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.mail.search.staff.config.ImmutableStaffConsumerConfig;

public class StaffConsumerServer
    extends HttpProxy<ImmutableStaffConsumerConfig>
{
    private final AsyncClient staffClient;
    private final AsyncClient producerClient;
    private final StaffConsumer consumer;
    private final StaffClient2 staffClient2;
    //private final StaffConsumer consumer;

    public StaffConsumerServer(
        final ImmutableStaffConsumerConfig config)
        throws IOException
    {
        super(config);

        this.staffClient =
            client("StaffClient", config.staffClientConfig());
        this.producerClient =
            client("ProducerClient", config.producerConfig());

        this.staffClient2 = new StaffClient2(this);
        this.consumer = new StaffConsumer(this, staffClient2);

        this.register(
            new Pattern<>("/staff/info", true),
            new GetInfoHandler(staffClient2));

        logger.info("Shared aceventura prefix is " + config.updatePrefix());
    }

    @Override
    public void start() throws IOException {
        super.start();
        consumer.start();
    }

    @Override
    public void close() throws IOException {
        consumer.close();
        super.close();
    }

    public AsyncClient staffClient() {
        return staffClient;
    }

    public AsyncClient producerClient() {
        return producerClient;
    }
}
