package ru.yandex.mail.search.staff.consumer;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.mail.search.staff.Person;

public class StaffMessage {
    private final List<Person> people;
    private final long messageId;

    public StaffMessage(final List<Person> people, long messageId) {
        this.people = people;
        this.messageId = messageId;
    }


    public StaffMessage(final long messageId) {
        this.people = new ArrayList<>();
        this.messageId = messageId;
    }

    public void add(final Person person) {
        this.people.add(person);
    }

    public List<Person> people() {
        return people;
    }

    public long messageId() {
        return messageId;
    }

    @Override
    public String toString() {
        return "StaffMessage{" +
            "people=" + people +
            ", messageId=" + messageId +
            '}';
    }
}
