package ru.yandex.mail.search.staff.consumer;

import java.util.ArrayList;
import java.util.List;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.protocol.HttpContext;

import ru.yandex.json.async.consumer.AbstractJsonAsyncTypesafeDomConsumer;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.StringCollectorsFactory;
import ru.yandex.mail.search.staff.Person;

public class StaffRecordsConsumer
    extends AbstractJsonAsyncTypesafeDomConsumer<StaffPage>
{
    public StaffRecordsConsumer(final HttpEntity entity) throws HttpException {
        super(
            entity,
            StringCollectorsFactory.INSTANCE,
            BasicContainerFactory.INSTANCE);
    }

    @Override
    protected StaffPage buildResult(
        final HttpContext context,
        final JsonObject rootObj)
        throws Exception
    {
        JsonMap root = rootObj.asMap();
        JsonMap links = root.getMap("links");
        String next = links.getString("next", null);

        JsonList results = root.getList("result");
        List<Person> people = new ArrayList<>(results.size());
        for (JsonObject itemObj: results) {
            people.add(new Person(itemObj.asMap()));
        }

        return new StaffPage(next, people);
    }
}
