package ru.yandex.mail.search.staff.consumer;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.http.util.HttpStatusPredicates;
import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;
import ru.yandex.http.util.nio.StatusCheckAsyncResponseConsumerFactory;

public enum  StaffRecordsConsumerFactory
    implements HttpAsyncResponseConsumerFactory<StaffPage>
{
    INSTANCE;

    public static final StatusCheckAsyncResponseConsumerFactory<StaffPage> OK =
        new StatusCheckAsyncResponseConsumerFactory<>(
            HttpStatusPredicates.OK,
            INSTANCE);

    @Override
    public StaffRecordsConsumer create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
        throws HttpException
    {
        return new StaffRecordsConsumer(response.getEntity());
    }
}
