package ru.yandex.mail.search.staff.consumer;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Supplier;

import org.apache.http.HttpHeaders;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.nio.client.methods.HttpAsyncMethods;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

public class StaffRequestProducerSupplier
    implements Supplier<HttpAsyncRequestProducer>
{
    private final URI uri;
    private final String token;

    public StaffRequestProducerSupplier(
        final String uri,
        final String token)
        throws URISyntaxException
    {
        this.uri = new URI(uri).parseServerAuthority();
        this.token = token;
    }

    @Override
    public HttpAsyncRequestProducer get() {
        HttpGet get = new HttpGet(uri);
        get.addHeader(
            HttpHeaders.AUTHORIZATION,
            "OAuth " + token);

        return HttpAsyncMethods.create(get);
    }
}
