package ru.yandex.mail.search.staff.consumer;

import java.util.logging.Level;

import ru.yandex.logger.PrefixedLogger;

public class WaitingStaffUpdateTaskCallback implements StaffUpdateTaskCallback {
    private static final long CHECK_INTERVAL = 200;

    public enum TaskStatus {
        RUNNING,
        FAILED,
        COMPLETED
    }

    private final PrefixedLogger logger;

    private final String lockId;
    private Long messageId;

    private volatile boolean cancelled = false;
    private volatile TaskStatus status = TaskStatus.RUNNING;

    public WaitingStaffUpdateTaskCallback(
        final PrefixedLogger logger,
        final String lockId,
        final Long startMessageId)
    {
        this.logger = logger;
        this.lockId = lockId;
        this.messageId = startMessageId;
    }

    @Override
    public String lockId() {
        return lockId;
    }

    @Override
    public synchronized Long startMessageId() {
        return messageId;
    }

    @Override
    public synchronized void updateMessageId(final long mId) {
        this.messageId = mId;
    }

    @Override
    public synchronized void completed(final Object o) {
        if (status != TaskStatus.RUNNING) {
            return;
        }

        status = TaskStatus.COMPLETED;
    }

    @Override
    public synchronized void failed(final Exception e) {
        if (status != TaskStatus.RUNNING) {
            return;
        }

        logger.log(Level.WARNING, "Failed to update staff ", e);
        status = TaskStatus.FAILED;
    }

    @Override
    public synchronized void cancelled() {
        if (status != TaskStatus.RUNNING) {
            return;
        }

        status = TaskStatus.FAILED;
    }

    public TaskStatus get() {
        try {
            while (!cancelled && (status == TaskStatus.RUNNING)) {
                Thread.sleep(CHECK_INTERVAL);
            }
        } catch (InterruptedException e) {
            logger.info("Updating interrupted");
            return TaskStatus.FAILED;
        }

        return status;
    }
}
