package ru.yandex.search.backpack.client;


import ru.yandex.client.tvm2.Tvm2ClientConfig;
import ru.yandex.client.tvm2.Tvm2ClientConfigBuilder;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.http.util.server.AbstractHttpProxyConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.searchmap.SearchMapConfig;
import ru.yandex.parser.searchmap.SearchMapConfigBuilder;
import ru.yandex.parser.string.NonEmptyValidator;

public abstract class AbstractBackPackClientConfigBuilder
    <T extends AbstractBackPackClientConfigBuilder<T>>
    extends AbstractHttpProxyConfigBuilder<T>
    implements BackPackClientConfig
{
    private SearchMapConfigBuilder searchMapConfig;
    private HttpHostConfigBuilder mdsWriterConfig;
    private HttpHostConfigBuilder mdsReaderConfig;
    private HttpHostConfigBuilder metaServerConfig;
    private HttpHostConfigBuilder consumerServerConfig;
    private Tvm2ClientConfigBuilder tvm2ClientConfig;
    private String mdsWriterTvmClientId;
    private String passExt;
    private String noHashExt;
    private long jobUpdateDelay;
    private int directProxyPort;
    private int clientInum;
    private String clientHostname;
    private boolean directUpload;
    private boolean toSalt;
    private String nameSpace;
//    private String backupType;
    private String expire;
//    private String backupPath;

    protected AbstractBackPackClientConfigBuilder(final BackPackClientConfig config) {
        super(config);
        searchMapConfig(config.searchMapConfig());
        mdsWriterConfig(config.mdsWriterConfig());

        tvm2ClientConfig(
                new Tvm2ClientConfigBuilder(config.tvm2ClientConfig()));
        mdsWriterTvmClientId(config.mdsWriterTvmClientId());
    }

    protected AbstractBackPackClientConfigBuilder(
        final IniConfig config,
        final BackPackClientConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        searchMapConfig = new SearchMapConfigBuilder(
                config.section("searchmap"),
                defaults.searchMapConfig());

        mdsWriterConfig = new HttpHostConfigBuilder(
                config.section("mds-writer"),
                defaults.mdsWriterConfig());

        mdsReaderConfig = new HttpHostConfigBuilder(
                config.section("mds-reader"),
                defaults.mdsReaderConfig());

        metaServerConfig = new HttpHostConfigBuilder(
                config.section("meta-server"),
                defaults.metaServerConfig());

        consumerServerConfig = new HttpHostConfigBuilder(
                config.section("consumer-server"),
                defaults.consumerServerConfig());

        tvm2ClientConfig = new Tvm2ClientConfigBuilder(
                config.section("tvm2"),
                defaults.tvm2ClientConfig());

        mdsWriterTvmClientId = config.get(
                "mdsWriter.tvm-client-id",
                defaults.mdsWriterTvmClientId(),
                NonEmptyValidator.INSTANCE);

        IniConfig backPackClientConfig = config.section("backpack-client");

        jobUpdateDelay = JOB_UPDATE_DELAY.extract(
                backPackClientConfig,
                defaults.jobUpdateDelay());

        directProxyPort = DIRECT_PROXY_PORT.extract(
                backPackClientConfig,
                defaults.directProxyPort());

        directUpload = backPackClientConfig.getBoolean("direct-upload", defaults.directUpload());

        toSalt = backPackClientConfig.getBoolean("to-salt", defaults.toSalt());

        nameSpace = NAMESPACE.extract(
                backPackClientConfig,
                defaults.nameSpace());

        clientInum = CLIENT_INUM.extract(
                backPackClientConfig,
                defaults.clientInum());

        clientHostname = CLIENT_HOST_NAME.extract(
                backPackClientConfig,
                defaults.clientHostname());

//        backupType = BACKUPTYPE.extract(
//                backPackClientConfig,
//                defaults.backupType());

        expire = EXPIRE.extract(
                backPackClientConfig,
                defaults.expire());

        passExt = PASSEXT.extract(
                backPackClientConfig,
                defaults.passExt());

        noHashExt = NOHASHEXT.extract(
                backPackClientConfig,
                defaults.noHashExt());

//        backupPath = BACKUPPATH.extract(
//                backPackClientConfig,
//                defaults.backupPath());
    }

    @Override
    public SearchMapConfigBuilder searchMapConfig() {
        return searchMapConfig;
    }

    public T searchMapConfig(final SearchMapConfig searchMapConfig) {
        this.searchMapConfig = new SearchMapConfigBuilder(searchMapConfig);
        return self();
    }

    @Override
    public HttpHostConfigBuilder mdsWriterConfig() {
        return mdsWriterConfig;
    }

    public T mdsWriterConfig(final HttpHostConfig mdsWriterConfig) {
        this.mdsWriterConfig = new HttpHostConfigBuilder(mdsWriterConfig);
        return self();
    }

    @Override
    public HttpHostConfigBuilder mdsReaderConfig() {
        return mdsReaderConfig;
    }

    public T mdsReaderConfig(final HttpHostConfig mdsReaderConfig) {
        this.mdsReaderConfig = new HttpHostConfigBuilder(mdsReaderConfig);
        return self();
    }

    @Override
    public HttpHostConfigBuilder metaServerConfig() {
        return metaServerConfig;
    }

    public T metaServerConfig(final HttpHostConfig metaServerConfig) {
        this.metaServerConfig = new HttpHostConfigBuilder(metaServerConfig);
        return self();
    }

    @Override
    public HttpHostConfigBuilder consumerServerConfig() {
        return consumerServerConfig;
    }

    public T consumerServerConfig(final HttpHostConfig consumerServerConfig) {
        this.consumerServerConfig = new HttpHostConfigBuilder(consumerServerConfig);
        return self();
    }

    @Override
    public Tvm2ClientConfigBuilder tvm2ClientConfig() {
        return tvm2ClientConfig;
    }

    public T tvm2ClientConfig(final Tvm2ClientConfig tvm2ClientConfig) {
        this.tvm2ClientConfig = new Tvm2ClientConfigBuilder(tvm2ClientConfig);
        return self();
    }

    @Override
    public String mdsWriterTvmClientId() {
        return mdsWriterTvmClientId;
    }

    public T mdsWriterTvmClientId(final String mdsWriterTvmClientId) {
        this.mdsWriterTvmClientId = mdsWriterTvmClientId;
        return self();
    }
    @Override
    public long jobUpdateDelay() {
        return jobUpdateDelay;
    }

    public T jobUpdateDelay(final long jobDelay) {
        this.jobUpdateDelay = jobDelay;
        return self();
    }

    @Override
    public int directProxyPort() {
        return directProxyPort;
    }

    public T directProxyPort(final int directProxyPort) {
        this.directProxyPort = directProxyPort;
        return self();
    }

    @Override
    public boolean directUpload() {
        return directUpload;
    }

    public T directUpload(final boolean directUpload) {
        this.directUpload = directUpload;
        return self();
    }

    @Override
    public boolean toSalt() {
        return toSalt;
    }

    public T toSalt(final boolean toSalt) {
        this.toSalt = toSalt;
        return self();
    }

    @Override
    public String nameSpace() {
        return nameSpace;
    }

    public T nameSpace(final String nameSpace) {
        this.nameSpace = nameSpace;
        return self();
    }

    @Override
    public String clientHostname() {
        return clientHostname;
    }

    public T clientHostname(final String clientHostname) {
        this.clientHostname = clientHostname;
        return self();
    }

    @Override
    public int clientInum() {
        return clientInum;
    }

    public T clientInum(final int clientInum) {
        this.clientInum = clientInum;
        return self();
    }

//    @Override
//    public String backupType() {
//        return backupType;
//    }
//
//    public T backupType(final String backupType) {
//        this.backupType = backupType;
//        return self();
//    }

    @Override
    public String expire() {
        return expire;
    }

    public T expire(final String expire) {
        this.expire = expire;
        return self();
    }

    @Override
    public String passExt() {
        return passExt;
    }

    public T passExt(final String passExt) {
        this.passExt = passExt;
        return self();
    }

    @Override
    public String noHashExt() {
        return noHashExt;
    }

    public T noHashExt(final String noHashExt) {
        this.noHashExt = noHashExt;
        return self();
    }

//    @Override
//    public String backupPath() {
//        return backupPath;
//    }
//
//    public T backupPath(final String backupPath) {
//        this.backupPath = backupPath;
//        return self();
//    }
}

