package ru.yandex.search.backpack.client;

import ru.yandex.client.tvm2.Tvm2ClientConfig;
import ru.yandex.function.GenericFunction;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.util.server.HttpProxyConfig;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.searchmap.SearchMapConfig;
import ru.yandex.parser.string.DoubleToIntegerValidator;
import ru.yandex.parser.string.DoubleToLongValidator;
import ru.yandex.parser.string.DurationParser;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.string.NonNegativeValidator;
import ru.yandex.parser.string.PatternValidator;

public interface BackPackClientConfig extends HttpProxyConfig {
    ParameterConfig<Long> JOB_UPDATE_DELAY = new ParameterConfig<>(
            "job-update-delay",
            DurationParser.INSTANCE.andThen(DoubleToLongValidator.INSTANCE),
            NonNegativeValidator.instance());

    ParameterConfig<Integer> DIRECT_PROXY_PORT = new ParameterConfig<>(
            "direct-proxy-port",
            DurationParser.INSTANCE.andThen(DoubleToIntegerValidator.INSTANCE),
            NonNegativeValidator.instance());

    ParameterConfig<String> NAMESPACE = new ParameterConfig<>(
            "namespace",
            GenericFunction.identity(),
            NonEmptyValidator.INSTANCE);

    ParameterConfig<Integer> CLIENT_INUM = new ParameterConfig<>(
            "client-inum",
            DurationParser.INSTANCE.andThen(DoubleToIntegerValidator.INSTANCE),
            NonNegativeValidator.instance());

    ParameterConfig<String> CLIENT_HOST_NAME = new ParameterConfig<>(
            "client-hostname",
            GenericFunction.identity(),
            NonEmptyValidator.INSTANCE);

//    ParameterConfig<String> BACKUPTYPE = new ParameterConfig<>(
//            "backup-type",
//            GenericFunction.identity(),
//            NonEmptyValidator.INSTANCE);

    ParameterConfig<String> EXPIRE = new ParameterConfig<>(
            "expire",
            GenericFunction.identity(),
            NonEmptyValidator.INSTANCE);

    ParameterConfig<String> PASSEXT = new ParameterConfig<>(
            "pass-ext",
            GenericFunction.identity(),
            PatternValidator.INSTANCE);

    ParameterConfig<String> NOHASHEXT = new ParameterConfig<>(
            "no-hash-ext",
            GenericFunction.identity(),
            PatternValidator.INSTANCE);


//    ParameterConfig<String> BACKUPPATH = new ParameterConfig<>(
//            "backup-path",
//            GenericFunction.identity(),
//            NonEmptyValidator.INSTANCE);

    long jobUpdateDelay();

    int directProxyPort();

    String nameSpace();

    int clientInum();

    String clientHostname();

//    String backupType();

    String expire();

    String noHashExt();

    String passExt();

    boolean directUpload();

    boolean toSalt();

//    String backupPath();

    SearchMapConfig searchMapConfig();

    HttpHostConfig mdsWriterConfig();

    HttpHostConfig mdsReaderConfig();

    HttpHostConfig metaServerConfig();

    HttpHostConfig consumerServerConfig();

    Tvm2ClientConfig tvm2ClientConfig();

    String mdsWriterTvmClientId();


}

