package ru.yandex.search.backpack.client;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class BackPackClientConfigBuilder
    extends AbstractBackPackClientConfigBuilder<BackPackClientConfigBuilder>
{
    public BackPackClientConfigBuilder() {
        super(BackPackClientConfigDefaults.INSTANCE);
    }

    public BackPackClientConfigBuilder(final BackPackClientConfig config) {
        super(config);
    }

    public BackPackClientConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, BackPackClientConfigDefaults.INSTANCE);
    }

    public BackPackClientConfigBuilder(
        final IniConfig config,
        final BackPackClientConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public BackPackClientConfigBuilder self() {
        return this;
    }

    public ImmutableBackPackClientConfig build() throws ConfigException {
        return new ImmutableBackPackClientConfig(this);
    }
}

