package ru.yandex.search.backpack.client;

import ru.yandex.client.tvm2.Tvm2ClientConfigDefaults;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigDefaults;
import ru.yandex.http.util.server.HttpProxyConfigDefaults;
import ru.yandex.parser.searchmap.SearchMapConfig;
import ru.yandex.parser.searchmap.SearchMapConfigDefaults;

public class BackPackClientConfigDefaults
    extends HttpProxyConfigDefaults
    implements BackPackClientConfig
{
    public static final BackPackClientConfigDefaults INSTANCE =
        new BackPackClientConfigDefaults();

    protected BackPackClientConfigDefaults() {
    }

    @Override
    public String name() {
        return "BackPack-Client";
    }

    @Override
    public SearchMapConfig searchMapConfig() {
        return SearchMapConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfig mdsWriterConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfig mdsReaderConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfig metaServerConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfig consumerServerConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public long jobUpdateDelay() {
        return -1L;
    }

    @Override
    public int directProxyPort() { return 1111; }

    @Override
    public boolean directUpload() {
        return false;
    }

    @Override
    public boolean toSalt() {
        return true;
    }

    @Override
    public String nameSpace() {
        return "sandbox-tmp";
    }

    @Override
    public String clientHostname() {
        return "default";
    }

    @Override
    public int clientInum() { return 0; }

//    @Override
//    public String backupType() {
//        return "simple";
//    }

    @Override
    public String expire() {
        return null;
    }

    @Override
    public String passExt() {
        return "";
    }

    @Override
    public String noHashExt() {
        return "";
    }

//    @Override
//    public String backupPath() {
//        return null;
//    }

    @Override
    public Tvm2ClientConfigDefaults tvm2ClientConfig() {
        return Tvm2ClientConfigDefaults.INSTANCE;
    }

    @Override
    public String mdsWriterTvmClientId() {
        return null;
    }


}

