package ru.yandex.search.backpack.client;

import ru.yandex.client.tvm2.ImmutableTvm2ClientConfig;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.util.server.ImmutableHttpProxyConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.searchmap.ImmutableSearchMapConfig;

public class ImmutableBackPackClientConfig
    extends ImmutableHttpProxyConfig
    implements BackPackClientConfig
{
    private final ImmutableSearchMapConfig searchMapConfig;
    private final ImmutableHttpHostConfig mdsWriterConfig;
    private final ImmutableHttpHostConfig mdsReaderConfig;
    private final ImmutableHttpHostConfig metaServerConfig;
    private final ImmutableHttpHostConfig consumerServerConfig;
    private final long jobUpdateDelay;
    private final int directProxyPort;
    private final boolean directUpload;
    private final boolean toSalt;
    private final String nameSpace;
    private final String clientHostname;
    private final int clientInum;
//    private final String backupType;
    private final String expire;
    private final String noHashExt;
    private final String passExt;
//    private final String backupPath;
    private final ImmutableTvm2ClientConfig tvm2ClientConfig;
    private final String mdsWriterTvmClientId;

    public ImmutableBackPackClientConfig(final BackPackClientConfig config)
        throws ConfigException
    {
        super(config);

        searchMapConfig = new ImmutableSearchMapConfig(
                config.searchMapConfig());
        jobUpdateDelay = JOB_UPDATE_DELAY.validate(config.jobUpdateDelay());

        directProxyPort = DIRECT_PROXY_PORT.validate(config.directProxyPort());

        directUpload = config.directUpload();
        toSalt = config.toSalt();

        nameSpace = NAMESPACE.validate(config.nameSpace());

        clientHostname = CLIENT_HOST_NAME.validate(config.clientHostname());

        clientInum = CLIENT_INUM.validate(config.clientInum());

//        backupType = BACKUPTYPE.validate(config.backupType());

        expire = EXPIRE.validate(config.expire());

        noHashExt = NOHASHEXT.validate(config.noHashExt());

        passExt = PASSEXT.validate(config.passExt());

//        backupPath = BACKUPPATH.validate(config.backupPath());

        mdsWriterConfig = new ImmutableHttpHostConfig(
                config.mdsWriterConfig());

        mdsReaderConfig = new ImmutableHttpHostConfig(
                config.mdsReaderConfig());

        metaServerConfig = new ImmutableHttpHostConfig(
                config.metaServerConfig());

        consumerServerConfig = new ImmutableHttpHostConfig(
                config.consumerServerConfig());

        tvm2ClientConfig =
                new ImmutableTvm2ClientConfig(config.tvm2ClientConfig());
        mdsWriterTvmClientId = config.mdsWriterTvmClientId();
    }

    @Override
    public ImmutableSearchMapConfig searchMapConfig() {
        return searchMapConfig;
    }

    @Override
    public ImmutableHttpHostConfig mdsWriterConfig() {
        return mdsWriterConfig;
    }

    @Override
    public ImmutableHttpHostConfig mdsReaderConfig() {
        return mdsReaderConfig;
    }

    @Override
    public ImmutableHttpHostConfig metaServerConfig() {
        return metaServerConfig;
    }

    @Override
    public ImmutableHttpHostConfig consumerServerConfig() {
        return consumerServerConfig;
    }

    @Override
    public ImmutableTvm2ClientConfig tvm2ClientConfig() {
        return tvm2ClientConfig;
    }

    @Override
    public String mdsWriterTvmClientId() {
        return mdsWriterTvmClientId;
    }

    @Override
    public long jobUpdateDelay() {
        return jobUpdateDelay;
    }

    @Override
    public int directProxyPort() {
        return directProxyPort;
    }

    @Override
    public boolean directUpload() {
        return directUpload;
    }

    @Override
    public boolean toSalt() {return toSalt; }

    @Override
    public String nameSpace() {
        return nameSpace;
    }

    @Override
    public String clientHostname() {
        return clientHostname;
    }

    @Override
    public int clientInum() {
        return clientInum;
    }


//    @Override
//    public String backupType() {
//        return backupType;
//    }

    @Override
    public String expire() {
        return expire;
    }

    @Override
    public String noHashExt() {
        return noHashExt;
    }

    @Override
    public String passExt() {
        return passExt;
    }

//    @Override
//    public String backupPath() {
//        return backupPath;
//    }


}

