package ru.yandex.search.backpack.client.handlers;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.json.dom.JsonBadCastException;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.msearch.Index;
import ru.yandex.search.backpack.client.BackPackClient;
import ru.yandex.search.backpack.client.BackPackRequestContext;
import ru.yandex.search.backpack.client.handlers.providers.FilePathBackupProvider;
import ru.yandex.util.timesource.TimeSource;

public class BackpackClientIndexHandler extends BackpackClientMainHandler {
    private PrefixedLogger logger;

    public BackpackClientIndexHandler(final BackPackClient backpack, Index index) {
        super(backpack, index);
        this.logger = backpack.logger();
    }

    @Override
    public void handle(
            final JsonObject payload,
            final HttpAsyncExchange exchange,
            final HttpContext context)
            throws HttpException {
        ProxySession session = new BasicProxySession(this.backpack, exchange, context);
        this.handle(new BackPackRequestContext(this.backpack, session), payload);
    }

    @Override
    public void handle(BackPackRequestContext context, JsonObject payload) {
        this.logger = context.session().logger();

        try{
            this.backupversion = payload.get("version").asString();
            this.service = payload.get("service").asString();
            this.shard = payload.get("shard").asString();

            //TODO: need backup in progress status - doesnot
            // upload files with same version until current backup is running

        } catch (JsonBadCastException e ) {
            logger.severe("Field 'version' or 'shard' doesnot specified." + e.getMessage());
            context.session().response(
                    HttpStatus.SC_BAD_REQUEST,
                    "Error");
            return;
        }


        this.backuppath = index.config().indexPath().getPath() + "/" + this.shard + "/";

        context.session().logger().info( "Starting backup" + this.backuppath);

        context.session().logger().info("Information from index:" + index.config().defaultFieldCodec());

        logger.info( "TTL is: " + TimeUnit.MILLISECONDS.toSeconds(TimeSource.INSTANCE.currentTimeMillis() + 100000));

        versBackupStatus = this.backpack.backupStat().computeIfAbsent(this.backupversion,
                k -> new ConcurrentHashMap<>());

        logger.info("Get backup version: " + this.backupversion);
        logger.info("Start backup provder.");

        Map<String, Map<String, String>> filemap = new FilePathBackupProvider(backuppath, context, this).getFilemap();

        logger.info("Initialize backup status.");

        for (Map.Entry<String, Map<String, String>> mapEntry : filemap.entrySet()) {
            logger.info("Initialize path: " + mapEntry.getKey() + " with value: " + STATUSPENDING);
            initBackupStatus(mapEntry);
        }

        final AsyncClient client =
                backpack.getMetaServerClient().adjust(context.session().context());

        try {
            mdsFileUpload(filemap,
                    client,
                    backpack,
                    context,
                    index.getShard(Integer.parseInt(this.shard)).numDocsLong());
        } catch (IOException e) {
            logger.severe("Cannot start backup upload host for service: "
                    + this.service
                    + " and version: "
                    + this.backupversion
                    + " error: "
                    + e.getMessage());
        }

        context.session().response(
                HttpStatus.SC_ACCEPTED,
                "OK");
    }
}
