package ru.yandex.search.backpack.client.handlers;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;

import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.json.writer.JsonType;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.msearch.Index;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.string.NonNegativeIntegerValidator;
import ru.yandex.search.backpack.client.BackPackClient;

public class BackpackClientShardControlHandler implements ProxyRequestHandler {
    private final Index index;
    private PrefixedLogger logger;
    private ConcurrentHashMap<String,String> istatus;

    public BackpackClientShardControlHandler(final BackPackClient backpack, Index index) {
        this.logger = backpack.logger();
        this.index = index;
        this.istatus = new ConcurrentHashMap<>();
    }

    @Override
    public void handle(ProxySession session) throws HttpException, IOException {
        this.logger = session.logger();

        String action = session.params().get(
                "action",
                NonEmptyValidator.INSTANCE);

        Integer shard = session.params().get(
                "shard",
                NonNegativeIntegerValidator.INSTANCE);

        istatus.put("indexingEnabled", String.valueOf(index.getShard(shard).indexingEnabled()));
        istatus.put("size_mb", String.valueOf(index.getShard(shard).indexSizeMb()));

        switch (action) {
            case "hold":
                logger.info("Set ro to shard: " + shard);
                index.getShard(shard).flush(false, true);
                index.getShard(shard).doFlush(true);
                break;
            case "unhold":
                logger.info("Set rw to shard: " + shard);
                index.getShard(shard).flush(true, false);
                break;
            case "status":
                session.response(
                        HttpStatus.SC_OK,
                        JsonType.NORMAL.toString(istatus));
                return;
            default:
                logger.severe("Wrong action." + action);
                session.response(
                        HttpStatus.SC_BAD_REQUEST,
                        "Error");
                return;
        }
        session.response(
                HttpStatus.SC_OK,
                "Done.");
    }
}
