package ru.yandex.search.backpack.client.handlers;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.json.dom.JsonBadCastException;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.search.backpack.client.BackPackClient;
import ru.yandex.search.backpack.client.BackPackRequestContext;
import ru.yandex.search.backpack.client.handlers.providers.FilePathBackupProvider;
import ru.yandex.util.timesource.TimeSource;


public class BackpackClientSimpleHandler extends BackpackClientMainHandler {
    private PrefixedLogger logger;

    public BackpackClientSimpleHandler(final BackPackClient backpack) {
        super(backpack);
    }

    @Override
    public void handle(
            final JsonObject payload,
            final HttpAsyncExchange exchange,
            final HttpContext context)
            throws HttpException {
        ProxySession session = new BasicProxySession(this.backpack, exchange, context);
        this.handle(new BackPackRequestContext(this.backpack, session), payload);
    }

    @Override
    public void handle(BackPackRequestContext context, JsonObject payload) throws HttpException {
        this.logger = context.session().logger();

        try{
            this.backupversion = payload.get("version").asString();
            this.backuppath = payload.get("path").asString();
            this.service = payload.get("service").asString();
            this.shard = payload.get("shard").asString();

            logger.info( "TTL is: " + TimeUnit.MILLISECONDS.toSeconds(TimeSource.INSTANCE.currentTimeMillis() + 100000));

            //TODO: need backup in progress status - doesnot
            // upload files with same version until current backup is running

        } catch (JsonBadCastException e ) {
            logger.severe("Some fields doesnot specified." + e.getMessage());
            e.printStackTrace();

            context.session().response(
                    HttpStatus.SC_BAD_REQUEST,
                    "Error");
            return;
        }

        versBackupStatus = this.backpack.backupStat().computeIfAbsent(this.backupversion,
                k -> new ConcurrentHashMap<>());

        logger.info("Get backup version: " + this.backupversion);
        logger.info("Start backup provder.");

        // TODO: change map to Map<String, Map<String, Map<String, String>>> where INT - shard number

        Map<String, Map<String, String>> filemap = new FilePathBackupProvider(backuppath, context, this).getFilemap();

        logger.info("Initialize backup status.");

        for (Map.Entry<String, Map<String, String>> mapEntry : filemap.entrySet()) {
            logger.info("Initialize path: " + mapEntry.getKey() + " with value: " + STATUSPENDING);
            initBackupStatus(mapEntry);
        }

        final AsyncClient client =
                backpack.getMdsWriterClient().adjust(context.session().context());

        try {
            mdsFileUpload(filemap, client, backpack, context);
        } catch (IOException e) {
            logger.severe("Cannot start backup upload host for service: "
                    + this.service
                    + " and version: "
                    + this.backupversion
                    + " error: "
                    + e.getMessage());
            e.printStackTrace();
        }

        context.session().response(
                HttpStatus.SC_ACCEPTED,
                "OK");
    }
}
