package ru.yandex.search.backpack.client.handlers;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.json.async.consumer.JsonAsyncTypesafeDomConsumerFactory;
import ru.yandex.json.dom.JsonBadCastException;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.search.backpack.client.BackPackClient;
import ru.yandex.search.backpack.client.BackPackRequestContext;
import ru.yandex.search.backpack.client.handlers.callbacks.MetaServerInfoCallback;
import ru.yandex.util.timesource.TimeSource;


public class BackpackClientSimpleRestoreHandler extends BackpackClientMainHandler {

    public BackpackClientSimpleRestoreHandler(final BackPackClient backpack) {
        super(backpack);
    }

    @Override
    public void handle(
            final JsonObject payload,
            final HttpAsyncExchange exchange,
            final HttpContext context)
            throws HttpException {
        ProxySession session = new BasicProxySession(this.backpack, exchange, context);
        this.handle(new BackPackRequestContext(this.backpack, session), payload);
    }

    @Override
    public void handle(BackPackRequestContext context, JsonObject payload) throws HttpException {
        PrefixedLogger logger = context.session().logger();

        String inum;
        try{
            this.backupversion = payload.get("version").asString();
            this.backuppath = payload.get("path").asStringOrNull();
            this.service = payload.get("service").asString();
            this.shard = payload.get("shard").asString();
            inum = String.valueOf(backpack.getClientinum());

            logger.info( "TTL is: " + TimeUnit.MILLISECONDS.toSeconds(TimeSource.INSTANCE.currentTimeMillis() + 100000));

            //TODO: need backup in progress status - doesnot
            // upload files with same version until current backup is running

        } catch (JsonBadCastException e ) {
            logger.severe("Some fields doesnot specified." + e.getMessage());
            e.printStackTrace();

            context.session().response(
                    HttpStatus.SC_BAD_REQUEST,
                    "Error");
            return;
        }

        logger.info("Get backup version: " + this.backupversion);
        logger.info("Get restore status.");

        QueryConstructor query =
                new QueryConstructor(
                        "/v1/backup/info?");
        query.append("version", backupversion);
        query.append("service", service);
        query.append("shard", shard);
        query.append("inum", inum);

        // Path not needed for index restore handler, for restoring by inum and shard - can be passed

        if (backuppath != null)
        {
            logger.info("Path param specified, backup files will be filtered by this path" + backuppath);
            query.append("path", URLEncoder.encode(backuppath, StandardCharsets.UTF_8));
        } else {
            logger.info("Path param NOT specified, backup files will be filtered by version" + backuppath);
        }

        final AsyncClient client =
                backpack.getMetaServerClient().adjust(context.session().context());

        Supplier<? extends HttpClientContext> contextGenerator =
                context.session().listener().createContextGeneratorFor(client);

        MetaServerInfoCallback callback;
        callback = new MetaServerInfoCallback(context, this);

        BasicAsyncRequestProducerGenerator producerGenerator =
                new BasicAsyncRequestProducerGenerator(query.toString());

        client.execute(backpack.config().metaServerConfig().host(),
                producerGenerator,
                JsonAsyncTypesafeDomConsumerFactory.OK,
                contextGenerator,
                callback
        );

        context.session().response(
                HttpStatus.SC_ACCEPTED,
                "OK");
    }
}
