package ru.yandex.search.backpack.client.handlers;

import org.apache.http.HttpStatus;

import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.json.writer.JsonType;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.search.backpack.client.BackPackClient;

public class BackpackClientStatHandler implements ProxyRequestHandler {
    private final BackPackClient backpack;
    private final PrefixedLogger logger;


    public BackpackClientStatHandler(final BackPackClient backpack) {
        this.backpack = backpack;
        this.logger = backpack.logger();
        this.logger.info("Backup handler4 called");
    }

    @Override
    public void handle(ProxySession session) throws BadRequestException {

        session.response(
                HttpStatus.SC_OK,
                JsonType.NORMAL.toString(this.backpack.backupStat()));
    }
}
