package ru.yandex.search.backpack.client.handlers.callbacks;

import org.apache.http.HttpResponse;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.logger.PrefixedLogger;
import ru.yandex.search.backpack.client.BackPackRequestContext;
import ru.yandex.search.backpack.client.handlers.BackpackClientMainHandler;

public final class BackpackMetaInfoCallback
        implements FutureCallback<HttpResponse> {

    private final PrefixedLogger logger;
    private final String path;

    public BackpackMetaInfoCallback(BackPackRequestContext context, BackpackClientMainHandler handler, String path) {
        this.logger = context.session().logger();
        this.path = path;
    }

    @Override
    public void completed(HttpResponse response) {
        int code = response.getStatusLine().getStatusCode();
        logger.info("Sending info request was succeeded. Answer code for path: " + path + " is: " + code);
    }


    @Override
    public void failed(Exception e) {
        logger.severe("Sending info request failed. Exception reached: " + path + " error: "
                + e.getMessage());
    }

    @Override
    public void cancelled() {

    }
}
