package ru.yandex.search.backpack.client.handlers.callbacks;

import java.io.IOException;
import java.nio.file.Paths;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.concurrent.FutureCallback;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import ru.yandex.logger.PrefixedLogger;
import ru.yandex.search.backpack.client.BackPackRequestContext;
import ru.yandex.search.backpack.client.handlers.BackpackClientMainHandler;

public final class MdsUploadCallback
        implements FutureCallback<HttpResponse> {

    private final String path;
    private final BackpackClientMainHandler handler;
    private final PrefixedLogger logger;
    private final BackPackRequestContext context;
//    private final BackPackClient backpack;
    private final String md5hash;
//    private final AsyncClient client;
    private String size;

    public MdsUploadCallback(BackPackRequestContext context, String md5hash, String path, BackpackClientMainHandler handler) {
        this.logger = context.session().logger();
        this.path = path;
        this.md5hash = md5hash;
        this.handler = handler;
        this.context = context;
//        this.backpack = context.backpack();
//        TODO: we need initialize info client in Main handler - to use one client for all info callbacks
//        this.client = backpack.getMetaServerClient().adjust(context.session().context());
        this.size = String.valueOf(Paths.get(path).toFile().length());
    }

    @Override
    public void completed(HttpResponse response) {
        int code = response.getStatusLine().getStatusCode();
        logger.info("Answer code for path: " + path + " is: " + code);

        HttpEntity entity = response.getEntity();

        //TODO: unfreeze index here need acces to Backpack?
        // How to do guarantee that index not be locked forever?

        try {
            if ( entity.getContent().available() != 0 ) {
                if ( code == HttpStatus.SC_FORBIDDEN ) {
                    //if status code = 403 key was already uploaded
                    // answer will be:

                    //<?xml version="1.0" encoding="utf-8"?>
                    // <post>
                    //<key>1395226//core/testdata/5_file_test4.txt</key>
                    //</post>
                    //

                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder;

                    builder = factory.newDocumentBuilder();
                    Document doc = builder.parse(entity.getContent());
                    NodeList list = doc.getElementsByTagName("key");
                    String key = list.item(0).getTextContent();

                    logger.info("Key was already uploaded: " + key + " for path: " + path);

                    BackpackClientMainHandler.setBackupStat(context,
                            handler,
                            path,
                            key,
                            size,
                            md5hash,
                            BackpackClientMainHandler.STATUSFINISHED,
                            BackpackClientMainHandler.OKMESSAGE);

                } else if ( code == HttpStatus.SC_OK) {
                    // answer will be:

                    // <?xml version="1.0" encoding="utf-8"?>
                    //<post obj="sandbox-tmp./core/testdata/15_file_test4.txt"
                    // id="574b33869d6b0809e4e1a81a4df02b7787725334c28f91061fcb7d2d37b1347634bd55578cd22c5bd6b02734a7c744473b3f2e957eaf4a6926ba0813514f2644" groups="2" size="17" key="1395226//core/testdata/15_file_test4.txt">
                    //<complete addr="a00:401::2a02:6b8:c08:f221" path="/srv/storage/1/1/data-0.2" group="1395368" status="0"/>
                    //<complete addr="a00:401::2a02:6b8:c04:145" path="/srv/storage/33/2/data-0.2" group="1395226" status="0"/>
                    //<written>2</written>
                    //</post>

                    DocumentBuilder documentBuilder =
                            DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    Document document = documentBuilder.parse(entity.getContent());
                    Element root = document.getDocumentElement();
                    String key = root.getAttribute("key");
                    this.size = root.getAttribute("size");

                    logger.info("New key was uploaded: " + key + " for path: " + path + " size:" + size);

                    BackpackClientMainHandler.setBackupStat(context,
                            handler,
                            path,
                            key,
                            size,
                            md5hash,
                            BackpackClientMainHandler.STATUSFINISHED,
                            BackpackClientMainHandler.OKMESSAGE);
                } else if ( code == HttpStatus.SC_PRECONDITION_FAILED) {
                    logger.severe("Precognition failed answer code: " + code);
                    BackpackClientMainHandler.setBackupStat(context,
                            handler,
                            path,
                            "none",
                            size,
                            md5hash,
                            BackpackClientMainHandler.STATUSERROR,
                            "Precognition failed, possibly file was changed (md5 hashsum mistmatch) during upload: "
                                    + code);
                } else {
                    logger.severe("Unsupported answer code: " + code);
                    BackpackClientMainHandler.setBackupStat(context,
                            handler,
                            path,
                            "none",
                            size,
                            md5hash,
                            BackpackClientMainHandler.STATUSERROR,
                            "Unsupported answer code: " + code);
                }
            } else {
                logger.severe("MDS return zero body, " +
                        "wrong request (expire or auth) answer code: "
                        + code);

                BackpackClientMainHandler.setBackupStat(context,
                        handler,
                        path,
                        "none",
                        size,
                        md5hash,
                        BackpackClientMainHandler.STATUSERROR,
                        "MDS return zero body, wrong request to MDS: " + code);
            }
        } catch (IOException | ParserConfigurationException | SAXException e) {
            String msg = "Cannot get MDS answer or upload stat to meta server " + e.getMessage();
            logger.severe(msg);

            BackpackClientMainHandler.setBackupStat(context,
                    handler,
                    path,
                    "none",
                    size,
                    md5hash,
                    BackpackClientMainHandler.STATUSERROR,
                    "Exception reached: " + msg);
        }
    }

    @Override
    public void failed(Exception e) {
        logger.severe("Exception reached: " + path + " error: "
                + e.getMessage());

        BackpackClientMainHandler.setBackupStat(context,
                handler,
                path,
                "none",
                size,
                md5hash,
                BackpackClientMainHandler.STATUSERROR,
                "Exception reached: " + path + " error: " + e.toString());

        //e.printStackTrace();
    }

    @Override
    public void cancelled() {

    }
}
