package ru.yandex.search.backpack.client.handlers.callbacks;


import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.function.Supplier;

import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.http.util.ErrorSuppressingFutureCallback;
import ru.yandex.http.util.MultiFutureCallback;
import ru.yandex.http.util.YandexHeaders;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.http.util.nio.client.FileCopyConsumerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonType;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.msearch.Index;
import ru.yandex.msearch.Shard;
import ru.yandex.search.backpack.client.BackPackClient;
import ru.yandex.search.backpack.client.BackPackRequestContext;
import ru.yandex.search.backpack.client.handlers.BackpackClientMainHandler;
import ru.yandex.search.backpack.client.handlers.providers.FilePathBackupProvider;

import static ru.yandex.msearch.ShardDropPolicy.RESTORE;
import static ru.yandex.search.backpack.client.handlers.BackpackClientMainHandler.DEFAULTSIZE;


public final class MetaServerInfoCallback
        implements FutureCallback<JsonObject> {
    private Index index;

    private final String path;
    private final BackPackRequestContext context;
    private final BackPackClient backpack;
    private final PrefixedLogger logger;
    private final BackpackClientMainHandler handler;

    public MetaServerInfoCallback(
            BackPackRequestContext context,
            BackpackClientMainHandler handler) {
        // TODO: turn saulted path in config
        this.path = handler.getPath();
        this.context = context;
        this.backpack = context.backpack();
        this.logger = context.session().logger();
        this.handler = handler;
        this.index = null;

    }

    public MetaServerInfoCallback(
            BackPackRequestContext context,
            BackpackClientMainHandler handler,
            Index index) {
        this(context, handler);
        this.index = index;
    }

    @Override
    public void completed(final JsonObject response) {
        // TODO: here we do multifuture callback and for every alement add

        MultiFutureCallback<DownloadResult> mfcb =
                new MultiFutureCallback<>(new RestoreDoneCallback(context.session(), handler));

        logger.info("Prepare for restoring");

//        final AsyncClient clientInit = context.backpack().getMetaServerClient().adjust(context.session().context());
//
//        BackpackMetaInfoCallback callback = new BackpackMetaInfoCallback(context, handler, path);
//
//        // Simple init restore action - create table and full it with records
//        // On init state will be setting to PENDING
//        clientInit.execute(backpack.config().metaServerConfig().host(),
//                new BasicAsyncRequestProducerGenerator(
//                        "/v1/restore/init",
//                        response.toString(),
//                        StandardCharsets.UTF_8),
//                context.session().listener().createContextGeneratorFor(clientInit),
//                callback
//        );

        try {
            JsonList paths = response.asList();
            for (JsonObject path: paths) {
                JsonMap map = path.asMap();

                String status = map.getString(handler.statusKey);
                String bpath = map.getString(handler.pathKey);
                String mdskey = map.getString(handler.mdsKey);
                String md5hash = map.getString(handler.md5Key);
                String rootPath = map.getString(handler.rootPathKey);
                String fsize = map.getString(handler.fsizeKey);
                //String rootpath = map.getString(handler.rootPathKey);

                logger.info("Status: "
                        + status
                        + " Backuped path: "
                        + bpath
                        + " MDSkey: "
                        + mdskey
                        + " md5hash: "
                        + md5hash
                        + " rootPath: "
                        + rootPath);

                // /ssd/messenger_messages/index
                Path rPath = Paths.get(rootPath);
//                logger.info("rPath " + rPath.toString());

                // /ssd/messenger_messages/index/61/write.lock
                Path bPath = Paths.get(bpath);
//                logger.info("bPath " + bPath.toString());

                // 61/write.lock
                Path relativePath = rPath.relativize(bPath);
//                logger.info("relativePath " + relativePath.toString());

                String filePath = relativePath.subpath(1,relativePath.getNameCount()).toString();
//                logger.info("filePath " + filePath);

                String bDirname = relativePath.getName(0).toString();
//                logger.info("bDirname " + bDirname);

                String recoveryDirname = bDirname
                        + "_restored"
                        + handler.getBackupversion();
//                logger.info("recoveryDirname " + recoveryDirname);

                String recoveryDirPath = rPath.toString() + "/" + recoveryDirname;
//                logger.info("recoveryDirPath " + recoveryDirPath);
                String recoveryFilePath = recoveryDirPath + "/" + filePath;
//                logger.info("recoveryFilePath " + recoveryFilePath);

                File restoreFile = new File(recoveryFilePath);

                if (Files.exists(Paths.get(recoveryFilePath).getParent())){
                    logger.info("Directory for restoring already exists: " + Paths.get(recoveryFilePath).getParent());

                    // TODO: make config - just drop all prev backup or check by md5 and size and do download
                    //  existing files

                    try {
                        String rMd5Hash = FilePathBackupProvider.computeContentMD5Header(new FileInputStream(restoreFile));
                        logger.info("File for restoring already exists. Check md5 and size and continue");
                        String rSize = String.valueOf(restoreFile.length());

                        if (md5hash.equals(rMd5Hash) && fsize.equals(rSize)) {
                            logger.info("Existing file equals to backup version. Pass with success and continue. "
                                    + " Path: "
                                    + restoreFile.toPath()
                                    + " Existing md5hash: "
                                    + rMd5Hash
                                    + " size: "
                                    + rSize
                                    + " Backup md5hash: "
                                    + md5hash
                                    + " size "
                                    + fsize);

                            BackpackClientMainHandler.setRestoreStat(context,
                                    handler,
                                    bpath,
                                    mdskey,
                                    fsize,
                                    md5hash,
                                    rootPath,
                                    BackpackClientMainHandler.STATUSFINISHED,
                                    BackpackClientMainHandler.OKMESSAGE);

                            continue;

                        } else {
                            logger.info("Existing file doesn't equals to backup version. Remove it and continue restore. "
                                    + " Path: "
                                    + restoreFile.toPath()
                                    + " Existing md5hash: "
                                    + rMd5Hash
                                    + " size: "
                                    + rSize
                                    + " Backup md5hash: "
                                    + md5hash
                                    + " size "
                                    + fsize);
                            boolean isDeleted = restoreFile.delete();
                            logger.info("File " + restoreFile.toPath() + " was deleted with status: " + isDeleted);
                        }

                    } catch (FileNotFoundException e) {
                        logger.info("Cannot compute md5 for file, possibly first try restore: " + Paths.get(recoveryFilePath).getParent());
                    }

                } else {
                    boolean cstatus = Paths.get(recoveryFilePath).getParent().toFile().mkdirs();

                    if (cstatus) {
                        logger.info("Path created: " + Paths.get(recoveryFilePath).getParent());
                    } else {
                        logger.info("Cannot create path: " + Paths.get(recoveryFilePath).getParent());
                    }
                }

                if(fsize.equals(DEFAULTSIZE)){
                    context.session().logger().warning("Do not restore zero size file, just create: "
                            + bpath);
                    BackpackClientMainHandler.setRestoreStat(context,
                            handler,
                            bpath,
                            mdskey,
                            fsize,
                            md5hash,
                            rootPath,
                            BackpackClientMainHandler.STATUSFINISHED,
                            BackpackClientMainHandler.OKMESSAGE);
                    try
                    {
                        //new File(recoveryFilePath).createNewFile();
                        restoreFile.createNewFile();
                    } catch ( IOException e) {
                        logger.severe("Cannot create empty path"
                                + recoveryFilePath
                                + " error: "
                                + e.getMessage());
                    }
                    continue;
                }

                BackpackClientMainHandler.setRestoreStat(context,
                        handler,
                        bpath,
                        mdskey,
                        fsize,
                        md5hash,
                        rootPath,
                        BackpackClientMainHandler.STATUSPENDING,
                        BackpackClientMainHandler.OKMESSAGE);

                final AsyncClient mdsReaderclient =
                        backpack.getMdsReaderClient().adjust(context.session().context());

                Supplier<? extends HttpClientContext> contextGenerator =
                        context.session().listener().createContextGeneratorFor(mdsReaderclient);

                BasicAsyncRequestProducerGenerator producerGenerator =
                        new BasicAsyncRequestProducerGenerator("/get-"
                                + backpack.getNamespace()
                                + "/"
                                + mdskey);

                producerGenerator.addHeader(
                        YandexHeaders.X_YA_SERVICE_TICKET,
                        backpack.mdsTvm2Ticket());

//                MdsGetFileCallback callback;

//                callback = new MdsGetFileCallback(
//                        bpath,
//                        rootPath,
//                        md5hash,
//                        context,
//                        handler);
//
//                client.execute(backpack.config().mdsReaderConfig().host(),
//                        producerGenerator,
//                        new FileCopyConsumerFactory(new File(recoveryFilePath)),
//                        contextGenerator,
//                        callback
//                );

                mdsReaderclient.execute(backpack.config().mdsReaderConfig().host(),
                        producerGenerator,
                        new FileCopyConsumerFactory(new File(recoveryFilePath)),
                        contextGenerator,
                        new DownloadParser(
                                //new File(recoveryFilePath),
                                restoreFile,
                                mdskey,
                                md5hash,
                                rootPath,
                                bpath,
                                new ErrorSuppressingFutureCallback<>(
                                        // TODO: actually we can send instance mfcb to our MdsGetFileCallback and
                                        //  just call .completed from here, do we need ErrorSupressingFuture callback here?
                                        mfcb.newCallback(),
                                        new DownloadResult(null, true, "Error")))
                );
            }

        } catch (JsonException e) {
            e.printStackTrace();
            logger.severe("Mailformed meta server json answer: " + JsonType.HUMAN_READABLE.toString(response));
        }

        mfcb.done();
    }

    @Override
    public void failed(final Exception e) {
        logger.severe("Cannot determine upload host for: " + path + " error: "
                + e.getMessage());

        handler.setBackupStatus(path,
                "none",
                BackpackClientMainHandler.STATUSERROR,
                "Cannot determine upload host for: " + path + " error: " + e.getMessage());
    }

    @Override
    public void cancelled() {
    }

    public final class DownloadParser
            extends AbstractFilterFutureCallback<File, DownloadResult>
    {
        private final File file;
        private final String mdskey;
        private final String md5hash;
        private final String rootPath;
        private final String bpath;

        private DownloadParser( File file,
                                String mdskey,
                                String md5hash,
                                String rootPath,
                                String bpath,
                                final FutureCallback<DownloadResult> callback)
        {
            super(callback);
            this.file = file;
            this.mdskey = mdskey;
            this.md5hash = md5hash;
            this.rootPath = rootPath;
            this.bpath = bpath;
        }

        @Override
        public void completed(File file) {
            logger.info("Download success.");
            // we must check that file was restored and send info request to backpack here

            BackpackClientMainHandler.setRestoreStat(context,
                    handler,
                    bpath,
                    mdskey,
                    String.valueOf(file.length()),
                    md5hash,
                    rootPath,
                    BackpackClientMainHandler.STATUSFINISHED,
                    BackpackClientMainHandler.OKMESSAGE);

            callback.completed(new DownloadResult(this.file, false, "OK"));
        }

        @Override
        public void failed(Exception e) {
            logger.info("File download error:" + this.file.toPath().toString() + " Exception: " + e.toString());
            callback.completed(new DownloadResult(this.file,true, e.getMessage()));
        }
    }

    // Class to store information about restored file
    // Send success request to backpack in constructor
    private final class DownloadResult {
        private final File file;
        private final String message;
        private boolean error;

        public DownloadResult(
                final File file,
                final boolean error,
                final String message)
        {
            this.error = error;
            this.file = file;
            this.message = message;
            logger.info("Information parsed");
        }

        public boolean getErr() {
            return error;
        }

        public File getFile() {
            return file;
        }

        public String getMessage() {
            return message;
        }
    }

    private final class RestoreDoneCallback
            extends AbstractProxySessionCallback<List<DownloadResult>>
    {
        private final BackpackClientMainHandler handler;
        private final PrefixedLogger logger;

        private RestoreDoneCallback(final ProxySession session, BackpackClientMainHandler handler) {
            super(session);

            this.handler = handler;
            this.logger = context.session().logger();
        }

        @Override
        public void completed(final List<DownloadResult> result) {
            // TODO: Here we know that all possible restored actions for shard was finished. We need check -
            //  if all done without errors we can move shard. Else - we can send info to meta server (or just do nothing)
            //  maybe we need send restore status to metaserver here and make another api for move shard (becaus if there error -
            //  we must decide about restore retry from external worker)

            this.logger.info("All files from shard was restored. Inum: " + backpack.getClientinum());
            boolean eflag = false;
            boolean consumerReset = false;

            for (DownloadResult dr : result) {
                if (dr.getErr())
                {
                    this.logger.warning("Restore errors logging."
                            + "File: "
                            + dr.getFile()
                            + " Message: "
                            + dr.getMessage());
                    eflag = true;
                }
            }
            if (index == null || handler.getAutoMove() == null) {
                this.logger.info("Looks like simple restore logic was called or automove disabled. Exiting.");
            } else {
                this.logger.info("Looks like additional restore logic was called. Try to move shard.");
                if (eflag){
                    this.logger.warning("Restore error detected, don't do any additional actions.");
                } else {
                    Shard shard = index.getShard(Integer.parseInt(handler.getShard()));
                    this.logger.info("Restore completed successfully. Move and reset shard: " + shard.shardNo);
                    try {
                        // TODO: After dropAndRecopy shard  will be initialized in readonly state
                        //  we need reset_shard for consumer before we enable readwrite state
                        //  we need execute internal consumer reset shard - http get is uglu
                        // move old shard to dir like 0-123412412412 and rename current restored dir to shardNo
                        shard.dropAndRecopy(logger, RESTORE, handler.getBackupversion());
                        // here we need call consumer to rest shard status

                        // We doesnot need service name anymore - consumer will reset shard
                        // for all services
//                        for (String service : backpack.searchMap().names()) {
                        String uri = "/reset_lucene_shard?shard=" + shard.shardNo
                                + "&lucene_shards_count=" + index.shardsCount();

                        this.logger.info("Services found: "
                                + " trying to execute: "
                                + backpack.config().consumerServerConfig().host()
                                + uri);

                        final AsyncClient client = context.backpack().getConsumerClient().adjust(context.session().context());

                        client.execute(backpack.config().consumerServerConfig().host(),
                                new BasicAsyncRequestProducerGenerator(uri),
                                context.session().listener().createContextGeneratorFor(client),
                                new BackpackMetaInfoCallback(context, handler, "consumer reset shard request")
                        );

//                        }
                        consumerReset = true;

                    } catch (IOException e) {
                        this.logger.warning("Cannot move shard: " + shard.shardNo + " Error: " + e.getMessage());
                        e.printStackTrace();
                    }

                    // Set rw state for shard after all
                    try {
                        shard.flush(true, false);
                    } catch (IOException e) {
                        // TODO: In that case we need kill lucene,
                        //  or check that indexing was enabled outside from worker, and consumer_reset=true
                        this.logger.warning("Can't turn on indexation on shard: "
                                + shard.shardNo
                                + " Error: "
                                + e.getMessage()
                                + " Consumer reset is "
                                + consumerReset);
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}


