package ru.yandex.search.backpack.client.handlers.callbacks;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import java.util.function.Supplier;

import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.client.methods.ZeroCopyPost;

import ru.yandex.http.util.YandexHeaders;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.search.backpack.client.BackPackClient;
import ru.yandex.search.backpack.client.BackPackRequestContext;
import ru.yandex.search.backpack.client.handlers.BackpackClientMainHandler;


public class ZeroCopySupplier implements Supplier<ZeroCopyPost> {

    private final String uri;
    private final String path;
    private final String md5Hash;
    private final BackPackClient backpack;
    private final PrefixedLogger logger;
    private final BackpackClientMainHandler handler;
    private boolean error;


    public ZeroCopySupplier(String uri,
                            String path,
                            String md5Hash,
                            BackPackRequestContext context,
                            BackpackClientMainHandler backpackHandler) {
        this.uri = uri;
        this.path = path;
        this.md5Hash = md5Hash;
        this.backpack = context.backpack();
        this.logger = context.session().logger();
        this.handler = backpackHandler;
        this.error = false;
    }

    @Override
    public ZeroCopyPost get() {
        try {
            return new ZeroCopyPost(
                    URI.create(uri),
                    new File(path),
                    ContentType.DEFAULT_BINARY) {

                @Override
                protected HttpEntityEnclosingRequest createRequest(
                        final URI requestURI, final HttpEntity entity) {
                    HttpEntityEnclosingRequest request = super.createRequest(requestURI, entity);
// Use OAUTH for sandbox purporses only
//                                        request.setHeader("Authorization",
//                                                "Basic " + OAUTH_TOKEN);
                    request.setHeader("Content-MD5", md5Hash);
                    request.addHeader(YandexHeaders.X_YA_SERVICE_TICKET,
                            backpack.mdsTvm2Ticket());
                    return request;
                }
            };
        } catch (FileNotFoundException e) {
            logger.severe("File moved during backup! File not found: " + e.getMessage());
            handler.setBackupStatus(path,
                    "none",
                    BackpackClientMainHandler.STATUSERROR,
                    "File moved during backup! File not found: " + e.getMessage());
            this.error = true;
        }
        return null;
    }

    public boolean getError(){
        return this.error;
    }
}
