package ru.yandex.search.so;

import java.io.File;

import ru.yandex.http.util.server.AbstractHttpProxyConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractBBNNConfigBuilder
    <T extends AbstractBBNNConfigBuilder<T>>
    extends AbstractHttpProxyConfigBuilder<T>
    implements BBNNConfig
{
    private int parseThreads;
    private int parseQueue;
    private File tablesPath;

    protected AbstractBBNNConfigBuilder(
        final BBNNConfig config)
        throws ConfigException
    {
        super(config);

        parseThreads = config.parseThreads();
        parseQueue = config.parseQueue();
        tablesPath = config.tablesPath();
    }

    protected AbstractBBNNConfigBuilder(
        final IniConfig config,
        final BBNNConfig defaults)
        throws ConfigException
    {
        super(config, defaults);

        parseThreads = config.getInt("parse-threads", defaults.parseThreads());
        parseQueue = config.getInt("parse-queue", defaults.parseQueue());
        tablesPath = config.getDir(
            "tables-path",
            defaults.tablesPath());
    }

    @Override
    public int parseThreads() {
        return parseThreads;
    }

    @Override
    public int parseQueue() {
        return parseQueue;
    }

    @Override
    public File tablesPath() {
        return tablesPath;
    }

    public T tablesPath(final File tablesPath) {
        this.tablesPath = tablesPath;
        return self();
    }

    public void copyTo(final AbstractBBNNConfigBuilder<?> other) {
        copyTo((AbstractHttpProxyConfigBuilder<?>) other);
    }
}
