package ru.yandex.search.so;

import java.io.IOException;

import ru.yandex.collection.Pattern;
import ru.yandex.concurrent.TimeFrameQueue;
import ru.yandex.http.proxy.HttpProxy;
import ru.yandex.http.util.request.RequestHandlerMapper;
import ru.yandex.stater.CountAggregatorFactory;
import ru.yandex.stater.DuplexStaterFactory;
import ru.yandex.stater.NamedStatsAggregatorFactory;
import ru.yandex.stater.PassiveStaterAdapter;

public class BBNN extends HttpProxy<ImmutableBBNNConfig> {
    private final TimeFrameQueue<Long> recordsProcessed;
    private final RecordHandler handler;

    public BBNN(final ImmutableBBNNConfig config)
        throws IOException
    {
        super(config);

        handler = new RecordHandler(
            this,
            logger().replacePrefix("HANDLER"),
            config.tablesPath());

        register(
            new Pattern<>("/logbroke-it", true),
            new LogbrokeItHandler(this, handler),
            RequestHandlerMapper.POST);

        recordsProcessed = new TimeFrameQueue<>(config.metricsTimeFrame());

        registerStater(
            new PassiveStaterAdapter<>(
                recordsProcessed,
                new DuplexStaterFactory<>(
                    new NamedStatsAggregatorFactory<>(
                        "records_processed_ammm",
                        CountAggregatorFactory.INSTANCE),
                    new NamedStatsAggregatorFactory<>(
                        "records_processed_axxx",
                        CountAggregatorFactory.INSTANCE))));
    }

    @Override
    public void close() throws IOException {
        super.close();
        handler.close();
    }

    public void processRecord() {
        recordsProcessed.accept(1L);
    }
}

