package ru.yandex.search.so;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class BBNNConfigBuilder
    extends AbstractBBNNConfigBuilder<
        BBNNConfigBuilder>
{
    public BBNNConfigBuilder()
        throws ConfigException
    {
        super(BBNNConfigDefaults.INSTANCE);
    }

    public BBNNConfigBuilder(
        final BBNNConfig config)
        throws ConfigException
    {
        super(config);
    }

    public BBNNConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, BBNNConfigDefaults.INSTANCE);
    }

    public BBNNConfigBuilder(
        final IniConfig config,
        final BBNNConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public BBNNConfigBuilder self() {
        return this;
    }

    public ImmutableBBNNConfig build()
        throws ConfigException
    {
        return new ImmutableBBNNConfig(this);
    }
}
