package ru.yandex.search.so;

import java.io.File;

import ru.yandex.http.util.server.ImmutableHttpProxyConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableBBNNConfig
    extends ImmutableHttpProxyConfig
    implements BBNNConfig
{
    private final int parseThreads;
    private final int parseQueue;
    private final File tablesPath;

    public ImmutableBBNNConfig(
        final BBNNConfig config)
        throws ConfigException
    {
        super(config);

        parseThreads = config.parseThreads();
        parseQueue = config.parseQueue();
        tablesPath = config.tablesPath();
    }

    @Override
    public int parseThreads() {
        return parseThreads;
    }

    @Override
    public int parseQueue() {
        return parseQueue;
    }

    @Override
    public File tablesPath() {
        return tablesPath;
    }
}
