package ru.yandex.search.so;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import ru.yandex.tskv.TskvException;
import ru.yandex.tskv.TskvHandler;
import ru.yandex.tskv.TskvRecord;

public class RecordHandler implements TskvHandler<TskvRecord> {
    private static final Pattern DEVID = Pattern.compile("devid=([^;]+)");
    private final Table badDevices;
    private final Table badUsers;
    private final Table badIPs;
    private final Logger logger;
    private final BBNN bbnn;

    RecordHandler(
        final BBNN bbnn,
        final Logger logger,
        final File dir)
        throws IOException
    {
        this.bbnn = bbnn;
        this.logger = logger;
        badDevices = new Table(dir, "bad-devices.txt");
        badUsers = new Table(dir, "bad-uids.txt");
        badIPs = new Table(dir, "bad-ips.txt");
    }

/*
        private boolean containsInKeys(
            final TskvRecord record,
            final String needle,
            final String... fields)
        {
            for (String field: fields) {
                final String value = record.get(field);
                if (value != null) {
                    if (value.contains(needle)) {
                        return true;
                    }
                }
            }
            return false;
        }
*/

    private boolean containsValues(
        final TskvRecord record,
        final String key,
        final String... values)
    {
        final String value = record.get(key);
        if (value != null) {
            for (String needle: values) {
                if (value.contains(needle)) {
                    return true;
                }
            }
        }
        return false;
    }

    private String get(final TskvRecord record, final String key) {
        String value = record.get(key);
        if (value == null) {
            value = "";
        }
        return value;
    }

    @Override
    public boolean onRecord(final TskvRecord record) {
        bbnn.processRecord();
//            if (containsValues(record, "action", "auth")
        if (containsValues(record, "comment", "devid")) {
            String comment = get(record, "comment");
            Matcher m = DEVID.matcher(comment);
            if (m.find()) {
                String devId = m.group(1);
                String userIp = get(record, "user_ip");
                String uid = get(record, "uid");
                if (badDevices.contains(devId)) {
                    if (userIp.length() > 4
                        && !"127.0.0.1".equals(userIp))
                    {
                        badIPs.add(userIp);
                        logger.info("BAD_IP: " + userIp);
                    }
                    if (uid.length() > 2) {
                        badUsers.add(uid);
                        logger.info("BAD_USER: " + uid);
                    }
                    logger.fine("DEVID: " + devId);
                    logger.fine(record.toString());
                } else {
                    if (badUsers.contains(uid)
                        && badIPs.contains(userIp)
                        && devId.length() > 5)
//                        && containsValues(record, "status", "failed"))
                    {
                        logger.info("BAD_DEVICE_BY_IP_UID: "
                            + devId + ", @" + userIp + " + " + uid);
                        badDevices.add(devId);
                        logger.fine("DEVID: " + devId);
                        logger.fine(record.toString());
                    }
                        //else if (badIPs.containsKey(userIp)) {
                        //    logger.info("BAD_DEVICE_BY_IP: " + userIp);
                        //    addDevice(devId);
                        //    logger.fine("DEVID: " + m.group(1));
                        //    logger.fine(record.toString());
                        //}
                }
            }
        }
        return true;
    }

    @Override
    public boolean onError(final TskvException exc) {
        logger.log(
            Level.SEVERE,
            "TskvParse error",
            exc);
        return true;
    }

    public void close() {
        badDevices.close();
        badUsers.close();
        badIPs.close();
    }
}
