package ru.yandex.search.so.bbnn_plus;

import java.io.File;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.http.util.server.AbstractHttpProxyConfigBuilder;
import ru.yandex.logger.LoggerConfigBuilder;
import ru.yandex.logger.MinimalLoggerConfigDefaults;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractBBNNPlusConfigBuilder
    <T extends AbstractBBNNPlusConfigBuilder<T>>
    extends AbstractHttpProxyConfigBuilder<T>
    implements BBNNPlusConfig
{
    private int parseThreads;
    private int parseQueue;
    private File tablesPath;
    private String supOAuthToken;
    private String push1Title;
    private String push1Body;
    private String push1Link;
    private String push2Title;
    private String push2Body;
    private String push2Link;
    private LoggerConfigBuilder depositLog;
    private LoggerConfigBuilder depositDebugLog;
    private HttpHostConfigBuilder sup;

    protected AbstractBBNNPlusConfigBuilder(
        final BBNNPlusConfig config)
        throws ConfigException
    {
        super(config);

        parseThreads = config.parseThreads();
        parseQueue = config.parseQueue();
        tablesPath = config.tablesPath();
        supOAuthToken = config.supOAuthToken();
        push1Title = config.push1Title();
        push1Body = config.push1Body();
        push1Link = config.push1Link();
        push2Title = config.push2Title();
        push2Body = config.push2Body();
        push2Link = config.push2Link();
        sup = new HttpHostConfigBuilder(config.sup());
        depositLog = new LoggerConfigBuilder(config.depositLog());
        depositDebugLog = new LoggerConfigBuilder(config.depositDebugLog());
    }

    protected AbstractBBNNPlusConfigBuilder(
        final IniConfig config,
        final BBNNPlusConfig defaults)
        throws ConfigException
    {
        super(config, defaults);

        parseThreads = config.getInt("parse-threads", defaults.parseThreads());
        parseQueue = config.getInt("parse-queue", defaults.parseQueue());
        tablesPath = config.getDir(
            "tables-path",
            defaults.tablesPath());
        supOAuthToken = config.getString(
            "sup-oauth-token",
            defaults.supOAuthToken());
        push1Title = config.getString(
            "push1-title",
            defaults.push1Title());
        push1Body = config.getString(
            "push1-body",
            defaults.push1Body());
        push1Link = config.getString(
            "push1-link",
            defaults.push1Link());

        push2Title = config.getString(
            "push2-title",
            defaults.push2Title());
        push2Body = config.getString(
            "push2-body",
            defaults.push2Body());
        push2Link = config.getString(
            "push2-link",
            defaults.push2Link());
        sup =
            new HttpHostConfigBuilder(
                config.section("sup"),
                defaults.sup());
        depositLog =
                new LoggerConfigBuilder(
                        config.section("deposit-log"),
                        MinimalLoggerConfigDefaults.INSTANCE);
        depositDebugLog =
                new LoggerConfigBuilder(
                        config.section("deposit-debug-log"),
                        MinimalLoggerConfigDefaults.INSTANCE);
    }

    @Override
    public int parseThreads() {
        return parseThreads;
    }

    @Override
    public int parseQueue() {
        return parseQueue;
    }

    @Override
    public File tablesPath() {
        return tablesPath;
    }

    public T tablesPath(final File tablesPath) {
        this.tablesPath = tablesPath;
        return self();
    }

    @Override
    public String supOAuthToken() {
        return supOAuthToken;
    }

    public T supOAuthToken(final String supOAuthToken) {
        this.supOAuthToken = supOAuthToken;
        return self();
    }

    @Override
    public String push1Title() {
        return push1Title;
    }

    public T push1Title(final String push1Title) {
        this.push1Title = push1Title;
        return self();
    }
    @Override
    public String push1Body() {
        return push1Body;
    }

    public T push1Body(final String push1Body) {
        this.push1Body = push1Body;
        return self();
    }
    @Override
    public String push1Link() {
        return push1Link;
    }

    public T push1Link(final String push1Link) {
        this.push1Link = push1Link;
        return self();
    }

    @Override
    public String push2Title() {
        return push2Title;
    }

    public T push2Title(final String push2Title) {
        this.push2Title = push2Title;
        return self();
    }
    @Override
    public String push2Body() {
        return push2Body;
    }

    public T push2Body(final String push2Body) {
        this.push2Body = push2Body;
        return self();
    }
    @Override
    public String push2Link() {
        return push2Link;
    }

    public T push2Link(final String push2Link) {
        this.push2Link = push2Link;
        return self();
    }

    @Override
    public HttpHostConfigBuilder sup() {
        return sup;
    }

    public T sup(final HttpHostConfig sup) {
        this.sup = new HttpHostConfigBuilder(sup);
        return self();
    }

    @Override
    public LoggerConfigBuilder depositLog() {
        return depositLog;
    }

    public void depositLog(LoggerConfigBuilder depositLog) {
        this.depositLog = depositLog;
    }

    @Override
    public LoggerConfigBuilder depositDebugLog() {
        return depositDebugLog;
    }

    public void depositDebugLog(LoggerConfigBuilder depositDebugLog) {
        this.depositDebugLog = depositDebugLog;
    }

    public void copyTo(final AbstractBBNNPlusConfigBuilder<?> other) {
        copyTo((AbstractHttpProxyConfigBuilder<?>) other);
        other.sup(sup);
    }
}
