package ru.yandex.search.so.bbnn_plus;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class BBNNPlusConfigBuilder
    extends AbstractBBNNPlusConfigBuilder<
        BBNNPlusConfigBuilder>
{
    public BBNNPlusConfigBuilder()
        throws ConfigException
    {
        super(BBNNPlusConfigDefaults.INSTANCE);
    }

    public BBNNPlusConfigBuilder(
        final BBNNPlusConfig config)
        throws ConfigException
    {
        super(config);
    }

    public BBNNPlusConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, BBNNPlusConfigDefaults.INSTANCE);
    }

    public BBNNPlusConfigBuilder(
        final IniConfig config,
        final BBNNPlusConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public BBNNPlusConfigBuilder self() {
        return this;
    }

    public ImmutableBBNNPlusConfig build()
        throws ConfigException
    {
        return new ImmutableBBNNPlusConfig(this);
    }
}
