package ru.yandex.search.so.bbnn_plus;

import java.io.File;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigDefaults;
import ru.yandex.http.util.server.HttpProxyConfigDefaults;
import ru.yandex.logger.LoggerConfig;
import ru.yandex.logger.LoggerConfigDefaults;

public class BBNNPlusConfigDefaults
    extends HttpProxyConfigDefaults
    implements BBNNPlusConfig
{
    public static final BBNNPlusConfigDefaults INSTANCE =
        new BBNNPlusConfigDefaults();
    private static final File DEFAULT_PATH = new File("/logs/");

    protected BBNNPlusConfigDefaults() {
    }

    @Override
    public int parseThreads() {
        return 1;
    }

    @Override
    public int parseQueue() {
        return 10;
    }

    @Override
    public File tablesPath() {
        return DEFAULT_PATH;
    }

    @Override
    public String supOAuthToken() {
        return "INVALID_TOKEN";
    }

    @Override
    public String push1Title() {
        return "Title1";
    }

    @Override
    public String push1Body() {
        return "Body1";
    }

    @Override
    public String push1Link() {
        return "http://ya.ru";
    }

    @Override
    public String push2Title() {
        return "Title2";
    }

    @Override
    public String push2Body() {
        return "Body2";
    }

    @Override
    public String push2Link() {
        return "http://ya.ru";
    }

    @Override
    public HttpHostConfig sup() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public LoggerConfig depositLog() {
        return LoggerConfigDefaults.INSTANCE;
    }

    @Override
    public LoggerConfig depositDebugLog() {
        return LoggerConfigDefaults.INSTANCE;
    }
}
