package ru.yandex.search.so.bbnn_plus;

import java.io.File;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.util.server.ImmutableHttpProxyConfig;
import ru.yandex.logger.ImmutableLoggerConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableBBNNPlusConfig
    extends ImmutableHttpProxyConfig
    implements BBNNPlusConfig
{
    private final int parseThreads;
    private final int parseQueue;
    private final File tablesPath;
    private final String supOAuthToken;
    private final String push1Title;
    private final String push1Body;
    private final String push1Link;
    private final String push2Title;
    private final String push2Body;
    private final String push2Link;
    private final ImmutableHttpHostConfig sup;
    private final ImmutableLoggerConfig depositLog;
    private final ImmutableLoggerConfig depositDebugLog;

    public ImmutableBBNNPlusConfig(
        final BBNNPlusConfig config)
        throws ConfigException
    {
        super(config);

        parseThreads = config.parseThreads();
        parseQueue = config.parseQueue();
        tablesPath = config.tablesPath();
        supOAuthToken = config.supOAuthToken();
        push1Title = config.push1Title();
        push1Body = config.push1Body();
        push1Link = config.push1Link();
        push2Title = config.push2Title();
        push2Body = config.push2Body();
        push2Link = config.push2Link();
        sup = new ImmutableHttpHostConfig(config.sup());
        depositLog = new ImmutableLoggerConfig(config.depositLog());
        depositDebugLog = new ImmutableLoggerConfig(config.depositDebugLog());
    }

    @Override
    public int parseThreads() {
        return parseThreads;
    }

    @Override
    public int parseQueue() {
        return parseQueue;
    }

    @Override
    public File tablesPath() {
        return tablesPath;
    }

    @Override
    public String supOAuthToken() {
        return supOAuthToken;
    }

    @Override
    public String push1Title() {
        return push1Title;
    }

    @Override
    public String push1Body() {
        return push1Body;
    }

    @Override
    public String push1Link() {
        return push1Link;
    }

    @Override
    public String push2Title() {
        return push2Title;
    }

    @Override
    public String push2Body() {
        return push2Body;
    }

    @Override
    public String push2Link() {
        return push2Link;
    }

    @Override
    public ImmutableHttpHostConfig sup() {
        return sup;
    }

    @Override
    public ImmutableLoggerConfig depositLog() {
        return depositLog;
    }

    @Override
    public ImmutableLoggerConfig depositDebugLog() {
        return depositDebugLog;
    }
}
