package ru.yandex.search.so.bbnn_plus;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.UUID;
import java.util.logging.Level;
//import java.util.logging.Logger;
//import java.util.regex.Matcher;
//import java.util.regex.Pattern;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.tskv.TskvException;
import ru.yandex.tskv.TskvHandler;
import ru.yandex.tskv.TskvRecord;

public class RecordHandler implements TskvHandler<TskvRecord> {
//    private static final Pattern DEVID = Pattern.compile("devid=([^;]+)");
    private final Table depositedUuids;
    private final Table depositedUids;
    private final PrefixedLogger logger;
    private final BBNNPlus bbnn;

    RecordHandler(
        final BBNNPlus bbnn,
        final PrefixedLogger logger,
        final File dir)
        throws IOException
    {
        this.bbnn = bbnn;
        this.logger = logger;

        depositedUuids = new Table(dir, "deposited-uuids.txt");
        depositedUids = new Table(dir, "deposited-uids.txt");
    }

    public int depositedCount() {
        return depositedUids.size();
    }

    private boolean containsInKeys(
        final TskvRecord record,
        final String needle,
        final String... fields)
    {
        for (String field: fields) {
            final String value = record.get(field);
            if (value != null) {
                if (value.contains(needle)) {
                    return true;
                }
            }
        }
        return false;
    }

/*
    private boolean containsValues(
        final TskvRecord record,
        final String key,
        final String... values)
    {
        final String value = record.get(key);
        if (value != null) {
            for (String needle: values) {
                if (value.contains(needle)) {
                    return true;
                }
            }
        }
        return false;
    }
*/
    private String get(final TskvRecord record, final String key) {
        String value = record.get(key);
        if (value == null) {
            value = "";
        }
        return value;
    }

    @Override
    public boolean onRecord(final TskvRecord record) {
        bbnn.processRecord();
        logger.finest("DUMP: " + record);
        if (
            record.containsKey("uuid")
            && containsInKeys(record, "OK", "status"))
        {
            final String uuid = get(record, "uuid");
            final String puid = get(record, "uid");
            if (uuid.length() > 5 && puid.length() > 1) {
                processUuid(new UserContext(uuid, puid, bbnn));
            }
        }
        return true;
    }

    private final void processUuid(final UserContext ctx) {
        ctx.debugLog().info("Processing uuid: " + ctx.uuid());
        if (bbnn.uuidAllowed(ctx.uuid())) {
            ctx.userLog().info("uuid in allowed list");
            if (depositedUuids.contains(ctx.uuid())) {
                ctx.userLog().info("This uuid has already been deposited");
            } else if (depositedUids.contains(ctx.puid())) {
                ctx.userLog().info("PUID: " + ctx.puid()
                    + " has aloread been deposited on another device");
            } else {
                try {
                    enlargePlus(ctx);
                } catch (IOException e) {
                    ctx.userLog().log(
                        Level.SEVERE,
                        "Plus enlarge fatal error",
                        e);
                    return;
                }
                depositedUuids.add(ctx.uuid());
                depositedUids.add(ctx.puid());
                try {
                    ctx.userLog().info("Scheduling second push");
                    bbnn.schedulePush(
                        ctx,
                        new SupResponseCallback(ctx),
                        false);
                } catch (Throwable e) {
                    ctx.userLog().log(
                        Level.SEVERE,
                        "Push scheduling fatal error",
                        e);
                }
            }
        } else {
            ctx.debugLog().info("Uuid is not in allowed list. skipping");
        }
    }

    private void enlargePlus(final UserContext ctx)
        throws IOException
    {
        final StringWriter sw = new StringWriter();
        try (
            JsonWriter writer = JsonType.NORMAL.create(sw))
        {
            writer.startObject();

            writer.key("uid");
            writer.value(ctx.puid());

            writer.key("campaign");
            writer.value("MBD-2024-login-to-yandex-app-200");

            writer.key("transactionId");
            UUID uuid = new UUID(
                (long) ctx.uuid().hashCode(),
                (long) ctx.uuid().hashCode());
            writer.value(uuid.toString());

            writer.endObject();
        }
        ctx.plusLog().finest(sw.toString());
    }

    @Override
    public boolean onError(final TskvException exc) {
        logger.log(
            Level.SEVERE,
            "TskvParse error",
            exc);
        return true;
    }

    public void close() {
        depositedUuids.close();
        depositedUids.close();
    }

    private static class SupResponseCallback
        implements FutureCallback<JsonObject>
    {
        private final UserContext ctx;

        SupResponseCallback(final UserContext ctx) {
            this.ctx = ctx;
        }

        @Override
        public void completed(final JsonObject response) {
            ctx.userLog().info(JsonType.NORMAL.toString(response));
            try {
                JsonMap map = response.asMap();
                final String id = map.getString("id");
                ctx.userLog().info("Push id: " + id);
            } catch (JsonException e) {
                ctx.userLog().log(
                    Level.SEVERE,
                    "Can't find push <ID> in sup response",
                    e);
            }
        }

        @Override
        public void failed(final Exception e) {
            ctx.userLog().log(
                Level.SEVERE,
                "Sup request failed",
                e);
        }

        @Override
        public void cancelled() {
            ctx.userLog().severe("sup request cancelled");
        }
    }
}
