package ru.yandex.search.so.bbnn_plus;

import java.io.IOException;
import java.util.logging.Level;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonType;

public class SendPushHandler implements ProxyRequestHandler
{
    private final BBNNPlus bbnn;

    public SendPushHandler(
        final BBNNPlus bbnn)
    {
        this.bbnn = bbnn;
    }

    public BBNNPlus bbnn() {
        return bbnn;
    }

    @Override
    public void handle(final ProxySession session)
        throws HttpException, IOException
    {
        final String uuid = session.params().getString("uuid");
        UserContext ctx =
            new UserContext(uuid, null, bbnn);
        final boolean skipCheck = session.params().getBoolean("skip-check", false);
        if (bbnn.uuidAllowed(uuid) && !skipCheck) {
            throw new BadRequestException(
                "Push to uuid: " + uuid + " has already been sent");
        }
        ctx.userLog().info("Sending promo push");
        bbnn.sendPush(ctx, new Callback(session, ctx), true);
    }


    private class Callback
        extends AbstractProxySessionCallback<JsonObject>
    {
        private final UserContext ctx;

        Callback(final ProxySession session, final UserContext ctx) {
            super(session);
            this.ctx = ctx;
        }

        @Override
        public void completed(final JsonObject response) {
            ctx.userLog().info(JsonType.NORMAL.toString(response));
            try {
                JsonMap map = response.asMap();
                final String id = map.getString("id");
                ctx.userLog().info("Push id: " + id);
            } catch (JsonException e) {
                ctx.userLog().log(
                    Level.SEVERE,
                    "Can't find push <ID> in sup response",
                    e);
            }
            bbnn.allowUuid(ctx.uuid());
            session.response(HttpStatus.SC_OK);
        }

        @Override
        public void failed(final Exception e) {
            ctx.userLog().log(
                Level.SEVERE,
                "Sup request failed",
                e);
            super.failed(e);
        }
    }
}
