package ru.yandex.search.so.bbnn_plus;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ConcurrentHashMap;

public class Table {
//    private final File dir;
//    private final String name;
    private final File file;
    private final ConcurrentHashMap<String, String> map;
    private final PrintStream out;

    public Table(final File dir, final String name) throws IOException {
//        this.dir = dir;
//        this.name = name;
        file = new File(dir, name);
        map = new ConcurrentHashMap<>();
        if (file.exists()) {
            load();
        }
        out = new PrintStream(
            new BufferedOutputStream(
                new FileOutputStream(file, true)));
    }

    public int size() {
        return map.size();
    }

    private final void load() throws IOException {
        try (
            BufferedReader reader =
                new BufferedReader(
                    new InputStreamReader(
                        new FileInputStream(file),
                        StandardCharsets.UTF_8)))
        {
            for (
                String line = reader.readLine();
                line != null;
                line = reader.readLine())
            {
                line = line.trim();
                if (line.startsWith("#") || line.length() == 0) {
                    continue;
                }
                map.put(line, line);
            }
        }
    }

    public boolean contains(final String value) {
        return map.containsKey(value);
    }

    public void add(final String value) {
        if (map.put(value, value) == null) {
            out.println(value);
            out.flush();
        }
    }

    public void close() {
        out.close();
    }
}
