package ru.yandex.search.so.bbnn_plus;

import java.util.logging.Logger;

public class UserContext {
    private final String uuid;
    private final String puid;
    private Logger plusLogger;
    private Logger userLogger;
    private Logger logger;

    UserContext(
        final String uuid,
        final String puid,
        final BBNNPlus bbnn)
    {
        this.uuid = uuid;
        this.puid = puid;
        final String prefix = "UUID<" + uuid + '>';
        this.userLogger = bbnn.depositDebugLogger().replacePrefix(prefix);
        this.logger = bbnn.logger().replacePrefix(prefix);
        this.plusLogger = bbnn.depositLogger();
    }

    public String uuid() {
        return uuid;
    }

    public String puid() {
        return puid;
    }

    public Logger userLog() {
        return userLogger;
    }

    public Logger plusLog() {
        return plusLogger;
    }

    public Logger debugLog() {
        return logger;
    }
}
