#!/bin/bash
set -exo pipefail

source config.sh

source classpath.sh

if [ "$MEM_LIMIT" != "" ]; then
    export MEMORY_LIMIT=$((MEM_LIMIT/100*80))
else
    export MEMORY_LIMIT=$(cat dump.json | jq -r '.container.constraints | .["slot.memory_limit"]' | awk '{print int($1*0.8)}')
fi
if [ "$CPU_LIMIT" != "" ]; then
    export CPU_CORES=$(echo $CPU_LIMIT | awk '{print int($1)}')
else
    export CPU_CORES=$(cat dump.json | jq -r '.container.constraints | .["slot.cpu_limit"]' | grep -Eo '[0-9\.]+' | awk '{print int($1)}')
fi

if jdk/bin/java -version 2>&1 | fgrep -q -e OpenJ9 -e Ibm -e IBM; then
    GC_ARGS="-Xgcpolicy:gencon -Xgcthreads$CPU_CORES -verbose:gc -Xverbosegclog:/dev/shm/gclogs/gc#.log,10,10000"
else
    GC_ARGS1="
    -XX:+PrintGC
    -XX:+PrintGCDetails
    -XX:+UnlockExperimentalVMOptions
    -verbose:gc
    -XX:+UseShenandoahGC
    -XX:ConcGCThreads=1
    -XX:ShenandoahGCMode=traversal
    -XX:-ShenandoahAlwaysClearSoftRefs
    -XX:ShenandoahAllocationThreshold=10
    -XX:ShenandoahGuaranteedGCInterval=30000
    -XX:ParallelGCThreads=$CPU_CORES
    -XX:+UnlockDiagnosticVMOptions
    -Xloggc:/dev/shm/gc.log
    "
    GC_ARGS="
    -XX:+PrintGC
    -XX:+PrintGCDetails
    -XX:+UnlockExperimentalVMOptions
    -verbose:gc
    -XX:+UseG1GC
    -Xmn512M
    -XX:ParallelGCThreads=$CPU_CORES
    -XX:ConcGCThreads=1
    -XX:G1ConcRefinementThreads=1
    -XX:MaxGCPauseMillis=10
    -XX:G1MixedGCCountTarget=32
    -XX:ConcGCThreads=1
    -XX:+UnlockDiagnosticVMOptions
    -XX:MaxHeapFreeRatio=30
    -XX:MinHeapFreeRatio=15
    -XX:InitiatingHeapOccupancyPercent=80
    -Xloggc:/dev/shm/gc.log
    "
fi

MEM_ARGS="-Xmx$MEMORY_LIMIT -Xms700M -Xmn512M"
NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"
exec $BSCONFIG_IDIR/jdk/bin/java \
    $JAVA_ARGS $GC_ARGS $NET_ARGS $MEM_ARGS \
    -Djava.library.path=. \
    -Djava.library.path=./bbnn_plus_service \
    -cp $CLASSPATH ru.yandex.search.so.bbnn_plus.BBNNPlus \
    bbnn.conf
