#!/bin/bash
#
# lucene-core	Start the Lucene Search Engine
#
# chkconfig: 345 98 05
# description: Lucene Search Engine
# processname: java


# Source function library

WDIR=`dirname $0`

export BSCONFIG_IPORT=7080
source classpath.sh

#prog="/usr/lib/jvm/java-1.7.0-ibm-wrt-3.64/bin/java"
prog1="/usr/lib/jvm/yandex-ibm-java/jre/bin/java"
prog="/home/tabolin/shenandoah/shenandoah-jdk-master/build/linux-x86_64-server-release/images/jdk/bin/java"
#prog="/home/tabolin/graalvm-ce-19.2.1/bin/java"
prog1="/home/tabolin/ibm/jdk-12.0.1+12/bin/java"
prog1="/home/tabolin/ibm/jdk-13+33/bin/java"
prog1="/home/tabolin/ibm/jdk-13.0.1+9/bin/java"
#prog="/u0/home/tabolin/ibm/openj9-openjdk-jdk13/build/linux-x86_64-server-release/images/jdk/bin/java"
#prog="/home/tabolin/ibm-java-x86_64-80.3.11/jre/bin/java"
#prog="/home/tabolin/ibm/jdk-10.0.1+10/bin/java"
#prog="/opt/ibm-java-x86_64-80/bin/java"
prog1="/home/tabolin/shenandoah/shenandoah-jdk9/build/linux-x86_64-normal-server-release/jdk/bin/java"
prog1="/home/tabolin/shenandoah/shenandoah-jdk8/build/linux-x86_64-normal-server-release/jdk/bin/java"
prog1="/home/tabolin/shenandoah/bin/jdk-11/bin/java"
prog1="/home/tabolin/shenandoah/zgc/jdk-13/bin/java"
prog1="/u0/home/tabolin/shenandoah/shenandoah-jdk-master/build/linux-x86_64-normal-server-release/images/jdk/bin/java"
prog1="/home/tabolin/shenandoah/jdk8u/build/linux-x86_64-normal-server-release/images/j2sdk-image/jre/bin/java"
prog1="/home/tabolin/shenandoah/jdk9/build/linux-x86_64-normal-server-release/jdk/bin/java"
#prog="/home/tabolin/shenandoah/jdk8u/build/linux-x86_64-normal-server-release/jdk/bin/java"
prog1="/home/tabolin/openjdk/jdk8u-master/jvm/openjdk-1.8.0-internal/jre/bin/java"
prog1="/usr/bin/java"
#prog="java"
#prog="/home/tabolin/openjdk/shenandoah/shenandoah/build/linux-x86_64-normal-client-slowdebug/jdk/bin/java"
progarg1="-Djava.library.path=search_backend_service -XX:-UseCompressedOops -XX:+UseConcMarkSweepGC -server -XX:ParallelGCThreads=20 -XX:SurvivorRatio=8 -XX:TargetSurvivorRatio=90 -XX:MaxTenuringThreshold=15 -XX:NewSize=5G -XX:MaxNewSize=5G -XX:ConcGCThreads=5 -verbose:gc -cp $CLASSPATH ru.yandex.search.so.Knn test_config.prod"
progarg="
-XX:+UnlockExperimentalVMOptions
-XX:+UseG1GC
-XX:ConcGCThreads=1
-XX:SoftRefLRUPolicyMSPerMB=1000
-XX:MaxGCPauseMillis=5
-XX:ParallelGCThreads=2
-XX:MaxTenuringThreshold=8
-XX:NewRatio=30
-XX:+UnlockDiagnosticVMOptions
-Xms3G
-Xmx3G -Djava.library.path=search_backend_service -cp $CLASSPATH ru.yandex.search.so.KnnUpload $*"
#-Xlog:gc*:/home/tabolin/log/lucene/gc.log


progarg1="-Xloggc:/home/tabolin/log/lucene/gc.log
-XX:+UnlockExperimentalVMOptions
-XX:+UnlockDiagnosticVMOptions
-XX:+UseZGC
-XX:ParallelGCThreads=2
-XX:ConcGCThreads=1
-XX:ZCollectionInterval=5
-XX:+PrintGC
-XX:+PrintGCDetails
-XX:MaxHeapFreeRatio=20
-XX:MinHeapFreeRatio=10
-XX:ZUncommitDelay=10
-verbose:gc -server -Xms3G -Xmx3G -Djava.library.path=search_backend_service -cp $CLASSPATH ru.yandex.search.so.Knn test_config.prod"
#progarg="-verbose:jni -XX:MaxGCPauseMillis=10 -XX:+UseG1GC -verbose:gc  -server -Xms1G -Xmx4G -Djava.library.path=search_backend_service -cp $CLASSPATH ru.yandex.search.so.Knn test_config.saas"
#-XX:-UseCompressedOops
progarg1="
-XX:+UnlockExperimentalVMOptions
-XX:+UseShenandoahGC
-XX:ConcGCThreads=1
-XX:ShenandoahAllocationThreshold=5
-XX:ShenandoahGCMode=traversal
-XX:ShenandoahUncommitDelay=3000
-XX:-ShenandoahAlwaysClearSoftRefs
-XX:ShenandoahGuaranteedGCInterval=30000
-XX:SoftRefLRUPolicyMSPerMB=1000
-XX:SoftRefPowLimitMB=600
-XX:+PrintCodeCache
-XX:ParallelGCThreads=2
-XX:+UnlockDiagnosticVMOptions
-Xloggc:/home/tabolin/log/knn/gc.log
-Xms32M
-Xmx3G -Djava.library.path=search_backend_service -cp $CLASSPATH ru.yandex.search.so.KnnUpload $*"

progarg1="
-XX:+PrintGC
-XX:+PrintGCDetails
-XX:+UnlockExperimentalVMOptions
-verbose:gc
-XX:+UseShenandoahGC
-XX:ConcGCThreads=1
-XX:ShenandoahGCHeuristics=static
-XX:-ShenandoahAlwaysClearSoftRefs
-XX:ShenandoahAllocationThreshold=10
-XX:ShenandoahUncommitDelay=30000
-XX:ShenandoahGuaranteedGCInterval=30000
-XX:ShenandoahGarbageThreshold=85
-XX:+PrintCodeCache
-XX:ParallelGCThreads=2
-XX:+UnlockDiagnosticVMOptions
-Xloggc:/home/tabolin/log/lucene/gc.log
-Xms512M
-Xmx3G -Djava.library.path=search_backend_service -cp $CLASSPATH ru.yandex.search.so.Knn test_config.prod"

progarg1="
-XX:+PrintGC
-XX:+PrintGCDetails
-XX:+UnlockExperimentalVMOptions
-verbose:gc
-XX:+UseShenandoahGC
-XX:ConcGCThreads=1
-XX:ShenandoahGCHeuristics=traversal
-XX:-ShenandoahAlwaysClearSoftRefs
-XX:ShenandoahAllocationThreshold=10
-XX:ShenandoahMinFreeThreshold=40
-XX:ShenandoahImmediateThreshold=1
-XX:ShenandoahGuaranteedGCInterval=30000
-XX:ShenandoahGarbageThreshold=95
-XX:+PrintCodeCache
-XX:ParallelGCThreads=2
-XX:+UnlockDiagnosticVMOptions
-Xloggc:/home/tabolin/log/lucene/gc.log
-Xms512M
-Xmx3G -Djava.library.path=search_backend_service -cp $CLASSPATH ru.yandex.search.so.Knn test_config.prod"

progarg1="
-XX:+PrintGC
-XX:+PrintGCDetails
-XX:+UnlockExperimentalVMOptions
-verbose:gc
-XX:+UseShenandoahGC
-XX:ConcGCThreads=1
-XX:ShenandoahGCHeuristics=adaptive
-XX:-ShenandoahAlwaysClearSoftRefs
-XX:ShenandoahGuaranteedGCInterval=30000
-XX:SoftRefLRUPolicyMSPerMB=1000
-XX:+PrintCodeCache
-XX:ParallelGCThreads=2
-XX:+UnlockDiagnosticVMOptions
-Xloggc:/home/tabolin/log/lucene/gc.log
-Xms512M
-Xmx3G -Djava.library.path=search_backend_service -cp $CLASSPATH ru.yandex.search.so.Knn test_config.prod"

progarg1="
-XX:+PrintGC
-XX:+PrintGCDetails
-XX:+UnlockExperimentalVMOptions
-verbose:gc
-XX:+UseG1GC
-Xmn64M
-XX:ConcGCThreads=1
-XX:SoftRefLRUPolicyMSPerMB=1000
-XX:+PrintCodeCache
-XX:ParallelGCThreads=2
-XX:+UnlockDiagnosticVMOptions
-Xloggc:/home/tabolin/log/lucene/gc.log
-Xms3G
-Xmx3G -Djava.library.path=search_backend_service -cp $CLASSPATH ru.yandex.search.so.Knn test_config.prod"

#-XX:ShenandoahUncommitDelay=30000
#-XX:CompileCommand=dontinline,org.apache.lucene.util.NativeIntArray::swap
#-XX:CompileCommand=dontinline,org.apache.lucene.util.NativeIntArray::swap
#-XX:+PrintAssembly
#-XX:+UseZGC
#-XX:+UseG1GC
#-XX:+UseShenandoahGC
#-XX:+UseEpsilonGC
#-XX:ParallelGCThreads=10
#progarg1="-Djava.library.path=../../lemmer/:../../allocator -XX:-UseCompressedOops -XX:+UseG1GC -server -XX:ParallelGCThreads=20 -XX:ConcGCThreads=5 -XX:MaxGCPauseMillis=50 -verbose:gc -cp $CLASSPATH ru.yandex.search.so.Knn test_config.xiva"
progarg1="
-Djava.library.path=search_backend_service
-Xgcpolicy:balanced
-verbose:gc
-Xverbosegclog:/home/tabolin/log/lucene/gc.log
-Xmx4G
-Xms4G
-Xmn32M
-Xgc:regionSize=$((512*1024))
-Xgcthreads6
-Xconcurrentbackground1
-Xsoftrefthreshold1000000000
-XXgc:tarokEnableIncrementalGMP
-XXgc:tarokEnableStableRegionDetection
-cp $CLASSPATH
ru.yandex.search.so.Knn test_config.prod"
#-XXgc:tarokEnableConcurrentGMP
#-Xtgc:compaction,concurrent,parallel,scavenger

#-Xgc:concurrentScavengeSlack=$((128*1024*1024))
#-Xconcurrentlevel4
#-Xconcurrentslack256M
#-Xgc:concurrentScavengeBackground=1
#-Xgc:concurrentScavenge
#-XX:IdleTuningGcOnIdle
#-XX:IdleTuningMinIdleWaitTime=1
#-Xgc:maxScavengeBeforeGlobal=10
#-Xtgc:concurrent
#-Xgc:maxScavengeBeforeGlobal=100
progarg1="
-Djava.library.path=search_backend_service
-Xgcpolicy:gencon
-verbose:gc
-Xverbosegclog:/home/tabolin/log/knn/gc.log
-Xgc:concurrentScavengeBackground=1
-Xgc:concurrentScavenge
-XX:IdleTuningGcOnIdle
-XX:IdleTuningMinIdleWaitTime=1
-Xmn512M
-Xmx1G
-Xmoi256M
-Xmaxe1G
-Xmint0.03
-Xgcthreads2
-Xgc:concurrentMark
-Xconcurrentbackground1
-Xaggressive
-Xsoftrefthreshold1000000000
-Xjit:scratchSpaceLimit=$((64*1024))
-DPORTO=1
-cp $CLASSPATH
ru.yandex.search.so.Knn knn.conf"

#-Xgc:concurrentCopyForward
progarg1="
-Djava.library.path=search_backend_service
-Xgcpolicy:balanced
-verbose:gc
-Xverbosegclog:/home/tabolin/log/lucene/gc.log
-Xgc:concurrentScavengeBackground=1
-Xgc:concurrentCopyForward
-Xgc:concurrentScavenge
-XX:IdleTuningGcOnIdle
-XX:IdleTuningMinIdleWaitTime=1
-Xmn512M
-Xmx10G
-Xms3G
-Xmoi256M
-Xmaxe1G
-Xmint0.03
-Xgcthreads6
-Xconcurrentbackground1
-Xgc:concurrentMark
-XXgc:concurrentSweep
-Xaggressive
-Xsoftrefthreshold1000000000
-Xjit:scratchSpaceLimit=$((64*1024))
-DPORTO=1
-cp $CLASSPATH
ru.yandex.search.so.Knn test_config.prod"

progarg1="
-Djava.library.path=search_backend_service
-Xgcpolicy:metronome
-verbose:gc
-Xverbosegclog:/home/tabolin/log/lucene/gc.log
-Xmx1G
-Xms1G
-Xgcthreads2
-Xgc:targetPausetime=10
-Xnoclassgc
-cp $CLASSPATH
ru.yandex.search.so.Knn knn.conf"
#-XconcurrentslackG

ulimit -s 1024
ulimit -n 1000000

#echo $prog $progarg
LD_PRELOAD=/usr/lib64/libtcmalloc_minimal.so
$prog $progarg
