package ru.yandex.bacchus;

import java.io.File;

import ru.yandex.dispatcher.consumer.ConsumerServer;
import ru.yandex.dispatcher.consumer.ConsumerServerFactory;
import ru.yandex.http.util.server.DefaultHttpServerFactory;
import ru.yandex.http.util.server.HttpServer;
import ru.yandex.ljinx.Ljinx;
import ru.yandex.msearch.Daemon;
import ru.yandex.ocr.proxy.OcrProxy;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.peach.Peach;
import ru.yandex.search.backpack.client.BackPackClient;
import ru.yandex.search.backpack.client.BackPackClientConfigBuilder;
import ru.yandex.search.disk.kali.Kali;
import ru.yandex.stater.PrefixingStater;

public final class Bacchus {
    private Bacchus() {
    }

    public static void main(final String... args) {
        int idx = 0;
        try {
            Daemon daemon = Daemon.createDaemon(args[idx++]);
            //Daemon.createDaemon(args[idx++]);
            HttpServer<?, ?> ljinx = Ljinx.main(
                new DefaultHttpServerFactory<>(Ljinx.class),
                args[idx++]);
            OcrProxy.main(
                new DefaultHttpServerFactory<>(OcrProxy.class),
                args[idx++])
                .registerStater(
                    new PrefixingStater("ljinx-", ljinx));
            Peach.main(
                new DefaultHttpServerFactory<>(Peach.class),
                args[idx++]);
            Kali.main(
                new DefaultHttpServerFactory<>(Kali.class),
                args[idx++]);
            ConsumerServer.main(
                new ConsumerServerFactory(),
                args[idx++]);
            new BackPackClient(new BackPackClientConfigBuilder( new IniConfig(
                    new File(args[idx]))).build(), daemon.index()).start();
        } catch (Throwable t) {
            t.printStackTrace();
            System.exit(-1);
        }
    }
}

