#!/bin/bash
set -exo pipefail

STARTING=0
NOT_STARTING=1

STATUS=$(cat lucene.status)
MTIME=$(stat -c %Y lucene.status)
TIME=$(date +%s)
ELAPSED=$((TIME-MTIME))

MAX_CLEANUP_TIME=120
MAX_SSD_INIT_TIME=7200
MAX_SHARD_INIT_TIME=21600
MAX_SERVER_INIT_TIME=120

case "$STATUS" in
    "STARTING CLEANUP"):
        if [ $ELAPSED -gt $MAX_CLEANUP_TIME ]; then
            exit $NOT_STARTING;
        else
            exit $STARTING;
        fi
        ;;
    "STARTING SSD_CACHE_INIT"):
        if [ $ELAPSED -gt $MAX_SSD_INIT_TIME ]; then
            exit $NOT_STARTING;
        else
            exit $STARTING;
        fi
        ;;
    "STARTING INDEX_INIT"):
        if [ $ELAPSED -gt $MAX_SHARD_INIT_TIME ]; then
            exit $NOT_STARTING;
        else
            exit $STARTING;
        fi
        ;;
    "STARTING SERVER_INIT"):
        if [ $ELAPSED -gt MAX_SERVER_INIT_TIME ]; then
            exit $NOT_STARTING;
        else
            exit $STARTING;
        fi
        ;;
    *)
        exit $NOT_STARTING;
esac

exit $NOT_STARTING
