#!/bin/bash
set -exo pipefail
source disk-config-base.sh

export SEARCH_PORT=$((BSCONFIG_IPORT + 1))
export INDEXER_PORT=$((BSCONFIG_IPORT + 2))
export CONSUMER_PORT=$((BSCONFIG_IPORT + 3))

export REPLICA_NAME=$(jq .leader.dynamicProperties.GENCFG_GROUP metainstance.json|tr -d '"'|tr 'A-Z_' 'a-z-')

export MTN_TAG=$(hostname -s)
#if [ "$LABELS_deploy_engine" = "YP_LITE" ]; then
#    export MTN_TAG=$(echo $HOSTNAME | cut -d '.' -f 1-2)
#    export REPLICA_NAME="$a_geo-disk-lucene"
#fi

export LJINX_PORT=48477
export SEARCH_BACKEND_SECTION="lucene"

# validate SEARCH_BACKEND_SECTION
egrep "\[[a-zA-Z_\-]+\]" ./instancectl.conf | grep -q "\[$SEARCH_BACKEND_SECTION\]" || exit 1


export INUM=$(cat inum.txt || echo False)
>&2 echo "Current inum is: $INUM"
export INUM_N=$(echo $INUM | cut -d ":" -f2)

if [ "$INUM" = "False" ]
then
   >&2 echo "$(date) inum.txt does not exists. Exiting. Inum is: $INUM"
   exit 1
fi

export LUCENE_DISK_CONFIG_SSD=$(if [ -d /ssd ]; then echo "bacchus-ssd.conf" ; else echo "bacchus-nossd.conf"; fi;)
export ISFAT=$(echo $BSCONFIG_ITAGS| grep -q "itag_diskfat"; if [ $? -eq 0 ]; then echo "FAT"; else echo "THIN";fi;)

export INDEX_BASE="/webcache/dsearch"

if [ "$ISFAT" = "FAT" ]; then
  export LUCENE_DISK_CONFIG_INCLUDE="search_backend_fat.conf"
else
  if [ -d /ssd ]; then
    # if there /ssd (cache) dir - it means backend lives on hdd volume
    export LUCENE_DISK_CONFIG_INCLUDE="search_backend_thin.conf"
  else
    # if there no /ssd (cache) dir - it means backends lives on ssd-only volume
    export LUCENE_DISK_CONFIG_INCLUDE="search_backend_thin_ssd.conf"
  fi
fi;

#override config for YP_Lite
if [ "$LABELS_deploy_engine" = "YP_LITE" ];then
    export MTN_TAG=$(echo $HOSTNAME | cut -d '.' -f 1-2)

    export REPLICA_NAME="$a_geo-disk-lucene"

    POD_NUM=$(echo "$YP_POD_ID" |  grep -o '[[:digit:]]*')
    if [ "$POD_NUM" -ge "1001" ]; then
        >&2 echo "$(date) Looks like this replica have number greater then 1000. This replica is extra"
        export REPLICA_NAME="all-disk-lucene-extra-replica"
    else
        >&2 echo "$(date) Replica name based on dc."
    fi

    # config optimized for ssd
    export LUCENE_DISK_CONFIG_INCLUDE="search_backend_thin_ssd.conf"
    # no cache
    export LUCENE_DISK_CONFIG_SSD="bacchus-nossd.conf"
    # index base on /ssd
    export INDEX_BASE="/ssd/dsearch"
fi

export LUCENE_SSD_CACHE_SIZE=$(df -B $((1024*1024*1024)) /ssd/ | grep /ssd | awk '{print int($2*0.95)}')
export INDEX_DIR="$INDEX_BASE/$INUM"


