#!/bin/bash
source config.sh
set -ex

which tvmknife || (apt-get update && apt-get install -y yandex-passport-tvmknife)

if [[ $# -eq 1 ]]; then
  export resid="$1"
  export uid=$(echo $1 | cut -d ':' -f1)
else
  if [[ $# -ne 2 ]]; then
    echo "Illegal number of parameters, expected 1 or 2 format: djfs.sh uid resourceId or just djfs.sh resourceId"
  fi

  export uid=$1
  export resid="$2"
fi

DEST_TVM_ID=$DISK_TVM_CLIENT_ID ./curl_tvm.sh -D -  "https://$DJFS_HOST/api/v1/indexer/resources?service=disk-search&uid=$uid&resourceId=$resid"